import http from "k6/http";
import { check, sleep, fail } from "k6";
import { textSummary } from "https://jslib.k6.io/k6-summary/0.0.1/index.js";

// =======================
// KONFIGURASI LOAD STRESS
// =======================
export let options = {
  scenarios: {
    max_login_test: {
      executor: "ramping-arrival-rate",
      startRate: 10, // mulai dari 10 login/detik
      timeUnit: "1s",
      preAllocatedVUs: 50,
      maxVUs: 1000, // batas maksimum virtual user
      stages: [
        { target: 50, duration: "30s" },
        { target: 100, duration: "30s" },
        { target: 200, duration: "30s" },
        { target: 300, duration: "30s" },
        { target: 400, duration: "30s" },
        { target: 500, duration: "30s" },
        { target: 0, duration: "10s" }, // ramp-down
      ],
    },
  },
  thresholds: {
    http_req_failed: ["rate<0.05"], // error < 5%
    http_req_duration: ["p(95)<3000"], // 95% request < 3 detik
  },
};

// =======================
// KONFIGURASI LOGIN
// =======================
const loginUrl = "https://duwijayaunderstel.cloud/api/login";
const payload = JSON.stringify({
  username: "q",
  password: "q",
});
const headers = {
  "Content-Type": "application/json",
};

// =======================
// FUNGSI LOGIN PER USER
// =======================
export default function () {
  const res = http.post(loginUrl, payload, { headers });

  const success = check(res, {
    "✅ status 200": (r) => r.status === 200,
    "✅ contains token": (r) => r.body.includes("token"),
  });

  if (!success) {
    console.error(`❌ Login failed — Status: ${res.status}`);
    fail("Login error / invalid response");
  }

  sleep(1); // simulasi user tunggu sebelum next action
}

// =======================
// OUTPUT FILE LOKAL
// =======================
export function handleSummary(data) {
  return {
    "max_login_summary.txt": textSummary(data, {
      indent: " ",
      enableColors: false,
    }),
    "max_login_summary.json": JSON.stringify(data, null, 2),
  };
}
