import http from "k6/http";
import { check, fail, sleep } from "k6";
import { textSummary } from "https://jslib.k6.io/k6-summary/0.0.1/index.js";

// === 1. Konfigurasi Test: Ramp-up sampai 60 VU selama 2 menit ===
export let options = {
  stages: [
    { duration: "2m", target: 60 }, // naik perlahan sampai 60 VU
    { duration: "1m", target: 60 }, // tahan 60 VU selama 1 menit
    { duration: "30s", target: 0 }, // ramp-down
  ],
  thresholds: {
    http_req_failed: ["rate<0.05"], // gagal < 5%
    http_req_duration: ["p(95)<3000"], // p95 < 3 detik
  },
};

// === 2. Fungsi Utama: Login di setiap VU ===
export default function () {
  const res = http.post(
    "https://duwijayaunderstel.cloud//api/login",
    JSON.stringify({
      username: "q",
      password: "q",
    }),
    {
      headers: { "Content-Type": "application/json" },
    }
  );

  const success = check(res, {
    "✅ Login sukses": (r) => r.status === 200 && r.body.includes("token"),
  });

  if (!success) {
    console.error(`❌ Login gagal | Status: ${res.status} | Body: ${res.body}`);
    fail("Login gagal");
  }

  sleep(1); // simulasi delay antar request
}

// === 3. Ringkasan Output ===
export function handleSummary(data) {
  return {
    "login_summary.txt": textSummary(data, {
      indent: " ",
      enableColors: false,
    }),
    "login_summary.json": JSON.stringify(data, null, 2),
  };
}
