import http from "k6/http";
import { check, sleep } from "k6";
import { textSummary } from "https://jslib.k6.io/k6-summary/0.0.1/index.js";

export let options = {
  vus: 10,
  duration: "1m",
  thresholds: {
    http_req_failed: ["rate<1"], // Sebagian besar request harus gagal
    http_req_duration: ["p(95)<5000"],
  },
};

export default function () {
  // Payload rusak: missing fields, format salah
  const invalidPayloads = [
    {}, // kosong
    { username: "" }, // tidak lengkap
    { email: "salahformat.com", password: 123 }, // format salah
    "ini_bukan_JSON", // payload bukan JSON
    null,
  ];

  const payload = JSON.stringify(
    invalidPayloads[Math.floor(Math.random() * invalidPayloads.length)]
  );

  const headers = { "Content-Type": "application/json" };

  const res = http.post(
    "https://duwijayaunderstel.cloud/api/register",
    payload,
    {
      headers,
    }
  );

  // Cek kalau response menunjukkan error yang tepat
  const isErrorHandled = check(res, {
    "⚠️ Status 400/422/500": (r) => [400, 422, 500].includes(r.status),
  });

  if (!isErrorHandled) {
    console.error(
      `❌ Respon tidak sesuai | Status: ${res.status} | Body: ${res.body}`
    );
  }

  sleep(1);
}

// Ringkasan hasil
export function handleSummary(data) {
  return {
    "error_handling_summary.txt": textSummary(data, {
      indent: " ",
      enableColors: false,
    }),
    "error_handling_summary.json": JSON.stringify(data, null, 2),
  };
}
