import http from "k6/http";
import { check, fail, sleep } from "k6";
import { textSummary } from "https://jslib.k6.io/k6-summary/0.0.1/index.js";

// === 1. Konfigurasi Peak Load Test ===
export let options = {
  stages: [
    { duration: "2m", target: 60 }, // naik dari 1 → 60 VU dalam 2 menit
    { duration: "10s", target: 0 }, // ramp-down cepat setelah peak
  ],
  thresholds: {
    http_req_failed: ["rate<0.05"], // Max 5% error
    http_req_duration: ["p(95)<4000"], // 95% response < 4 detik
  },
};

// === 2. Fungsi Register Otomatis ===
export default function () {
  const randomNum = Math.floor(Math.random() * 1000000);

  const payload = JSON.stringify({
    username: `user_${__VU}_${randomNum}`,
    email: `user_${__VU}_${randomNum}@mail.com`,
    password: `pass_${randomNum}`,
    nomor_telepon: `0812${Math.floor(1000000 + Math.random() * 8999999)}`,
    peran: "member",
  });

  const headers = { "Content-Type": "application/json" };

  const res = http.post(
    "https://ggbpuhwbr1.execute-api.us-east-1.amazonaws.com/dev/api/register",
    payload,
    { headers }
  );

  const ok = check(res, {
    "✅ Register berhasil (201)": (r) =>
      r.status === 201 && r.body.includes("Registrasi berhasil"),
  });

  if (!ok) {
    console.error(
      `❌ Register gagal | Status: ${res.status} | Body: ${res.body}`
    );
    fail("Registrasi gagal");
  }

  sleep(1);
}

// === 3. Output Summary ===
export function handleSummary(data) {
  return {
    "register_peakload_autogen.txt": textSummary(data, {
      indent: " ",
      enableColors: false,
    }),
    "register_peakload_autogen.json": JSON.stringify(data, null, 2),
  };
}
