package com.projectku.ecommercefirebase.fragment

import android.content.Intent
import android.content.SharedPreferences
import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import com.google.firebase.auth.FirebaseAuth
import com.google.firebase.firestore.ktx.firestore
import com.google.firebase.ktx.Firebase
import com.projectku.ecommercefirebase.MainActivity
import com.projectku.ecommercefirebase.R
import com.projectku.ecommercefirebase.databinding.FragmentCartBinding
import com.projectku.ecommercefirebase.databinding.FragmentMoreBinding


class MoreFragment : Fragment() {

    private lateinit var binding: FragmentMoreBinding
    private lateinit var preferences: SharedPreferences
    private lateinit var auth: FirebaseAuth
    private lateinit var builder: AlertDialog.Builder

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = FragmentMoreBinding.inflate(layoutInflater)

        //activity?.setTitle("Profile")
        preferences = requireContext().getSharedPreferences("user", AppCompatActivity.MODE_PRIVATE)

        // Inflate the layout for this fragment

        builder = AlertDialog.Builder(requireContext())

        getUser()
        onLogoutClick()

        auth = FirebaseAuth.getInstance()



        return binding.root
    }

    private fun getUser() {
        Firebase.firestore.collection("users")
            .document(preferences.getString("number", "")!!)
            .get().addOnSuccessListener {
                binding.tvUserName.text = it.getString("userName")
                //binding.tvNumber.text = it.getString("userPhoneNumber")
            }
            .addOnFailureListener {
                Toast.makeText(context, "Something an error", Toast.LENGTH_SHORT).show()
            }
    }

    private fun onLogoutClick(){
        binding.linearOut.setOnClickListener {
            builder.setTitle("Alert!")
                .setMessage("Do you want to exit?")
                .setCancelable(true)
                .setPositiveButton("Yes"){dialogInterface, it ->
                    auth.signOut()
                    startActivity(Intent(context, MainActivity::class.java))
                    activity?.finish()
                    activity?.finish()
                }
                .setNegativeButton("No"){dialogInterface,it ->
                    dialogInterface.cancel()
                }
                .show()

        }
    }




}