package com.projectku.ecommercefirebase.fragment

import android.content.Intent
import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.appcompat.app.AppCompatActivity
import com.projectku.ecommercefirebase.R
import com.projectku.ecommercefirebase.activity.AddressActivity
import com.projectku.ecommercefirebase.activity.CategoryActivity
import com.projectku.ecommercefirebase.adapter.CartAdapter
import com.projectku.ecommercefirebase.databinding.FragmentCartBinding
import com.projectku.ecommercefirebase.databinding.FragmentHomeBinding
import com.projectku.ecommercefirebase.roomdb.AppDatabase
import com.projectku.ecommercefirebase.roomdb.ProductModel
import com.projectku.ecommercefirebase.utils.Helper.formatPrice
import java.text.NumberFormat
import java.util.*


class CartFragment : Fragment() {

    private lateinit var binding: FragmentCartBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)



    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        binding = FragmentCartBinding.inflate(layoutInflater)

       // activity?.setTitle("Cart")

        val preference = requireContext().getSharedPreferences("info", AppCompatActivity.MODE_PRIVATE)
        val editor = preference.edit()
        editor.putBoolean("isCart", false)
        editor.apply()


        val dao = AppDatabase.getInstance(requireContext()).productDao()

        dao.getAllProducts().observe(requireActivity()){
            binding.recyclerViewCart.adapter = CartAdapter(requireContext(), it)

            totalCost(it)
        }

        return binding.root
    }

    private fun totalCost(data: List<ProductModel>?) {
        val formatter  = NumberFormat.getCurrencyInstance(Locale("in","ID"))
        var total = 0
        for(item in data!!){
            total += item.productSp!!.toInt()
        }

        binding.tvTotalItem.text = "Total item in cart is ${data.size}"
        binding.tvTotalCost.formatPrice("$total")

        binding.btnCheckout.setOnClickListener {
            val intent = Intent(context, AddressActivity::class.java)
            intent.putExtra("totalCost", total.toString())
            startActivity(intent)
        }
    }

}