package com.projectku.ecommercefirebase.adapter

import android.content.Context
import android.content.Intent
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.projectku.ecommercefirebase.R
import com.projectku.ecommercefirebase.activity.ProductDetailActivity
import com.projectku.ecommercefirebase.databinding.LayoutProductBinding
import com.projectku.ecommercefirebase.model.AddProductModel
import com.projectku.ecommercefirebase.utils.Helper.formatPrice

class ProductAdapter(val context: Context, val list: ArrayList<AddProductModel>): RecyclerView.Adapter<ProductAdapter.ViewHolder>() {
    inner class ViewHolder(val binding: LayoutProductBinding): RecyclerView.ViewHolder(binding.root) {

    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val binding = LayoutProductBinding.inflate(LayoutInflater.from(context), parent, false)
        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val data = list[position]

        Glide.with(context).load(data.productCoverImg).placeholder(R.drawable.proggres_animation).into(holder.binding.imageView2)
        holder.binding.textView2.text = data.productName
        holder.binding.textView3.text = data.productCategory
        holder.binding.textView4.formatPrice(data.productMrp)

        holder.binding.button.formatPrice(data.productSp)

        holder.itemView.setOnClickListener {
            val intent = Intent(context, ProductDetailActivity::class.java)
            intent.putExtra("id", list[position].productId)
            context.startActivity(intent)
        }
    }

    override fun getItemCount(): Int = list.size
}