package com.projectku.ecommercefirebase.adapter

import android.content.Context
import android.content.Intent
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.projectku.ecommercefirebase.R
import com.projectku.ecommercefirebase.activity.ProductDetailActivity
import com.projectku.ecommercefirebase.databinding.LayoutCategoryProductBinding
import com.projectku.ecommercefirebase.model.AddProductModel
import com.projectku.ecommercefirebase.model.CategoryModel
import com.projectku.ecommercefirebase.utils.Helper.formatPrice

class CategoryProductAdapter(var context: Context, val list: ArrayList<AddProductModel>) :
    RecyclerView.Adapter<CategoryProductAdapter.ViewHolder>() {

    inner class ViewHolder(val binding: LayoutCategoryProductBinding) :
        RecyclerView.ViewHolder(binding.root) {

    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val binding =
            LayoutCategoryProductBinding.inflate(LayoutInflater.from(context), parent, false)
        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        Glide.with(context).load(list[position].productCoverImg).placeholder(R.drawable.proggres_animation).into(holder.binding.imageView)
        holder.binding.textView1.text = list[position].productName
        holder.binding.textView2.formatPrice(list[position].productSp)

        holder.itemView.setOnClickListener {
            val intent = Intent(context, ProductDetailActivity::class.java)
            intent.putExtra("id", list[position].productId)
            context.startActivity(intent)
        }
    }

    override fun getItemCount(): Int = list.size
}