package com.projectku.ecommercefirebase.adapter

import android.content.Context
import android.content.Intent
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.projectku.ecommercefirebase.R
import com.projectku.ecommercefirebase.activity.CategoryActivity
import com.projectku.ecommercefirebase.databinding.LayoutCategoryBinding
import com.projectku.ecommercefirebase.model.CategoryModel

class CategoryAdapter(var context: Context, val list: ArrayList<CategoryModel>) : RecyclerView.Adapter<CategoryAdapter.ViewHolder>() {

    inner class ViewHolder(view: View): RecyclerView.ViewHolder(view) {
        var binding = LayoutCategoryBinding.bind(view)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(LayoutInflater.from(context).inflate(R.layout.layout_category, parent ,false))
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.binding.tvItemCategory?.text = list[position].cat
        Glide.with(context)
            .load(list[position].img)
            .placeholder(R.drawable.proggres_animation)
            .into(holder.binding.imgItemCategory)

        holder.itemView.setOnClickListener {
            val intent = Intent(context, CategoryActivity::class.java)
            intent.putExtra("cat", list[position].cat) //parsing with key cat to CategoryActivity
            context.startActivity(intent)
        }
    }

    override fun getItemCount(): Int = list.size

}


