package com.projectku.ecommercefirebase.adapter

import android.content.Context
import android.content.Intent
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.projectku.ecommercefirebase.activity.ProductDetailActivity
import com.projectku.ecommercefirebase.databinding.LayoutCartItemBinding
import com.projectku.ecommercefirebase.roomdb.AppDatabase
import com.projectku.ecommercefirebase.roomdb.ProductModel
import com.projectku.ecommercefirebase.utils.Helper.formatPrice
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import java.text.NumberFormat
import java.util.*

class CartAdapter(var context: Context, val list: List<ProductModel>) :
    RecyclerView.Adapter<CartAdapter.ViewHolder>() {



    inner class ViewHolder(val binding: LayoutCartItemBinding) :
        RecyclerView.ViewHolder(binding.root)


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val binding = LayoutCartItemBinding.inflate(LayoutInflater.from(context), parent, false)
        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        Glide.with(context).load(list[position].productImage).into(holder.binding.imageView)
        holder.binding.textView1.text = list[position].productName
        //holder.binding.textView2.text = "Rp.${list[position].productSp}"
        holder.binding.textView2.formatPrice(list[position].productSp)

        holder.itemView.setOnClickListener {
            val intent = Intent(context, ProductDetailActivity::class.java)
            intent.putExtra("id", list[position].productId) //parsing with key id
            context.startActivity(intent)
        }


        val dao = AppDatabase.getInstance(context).productDao()
        holder.binding.ivClose.setOnClickListener {
            GlobalScope.launch(Dispatchers.IO) {
                dao.deleteProduct(
                    ProductModel(
                        list[position].productId,
                        list[position].productName,
                        list[position].productImage,
                        list[position].productSp,
                    )
                )
            }
        }
    }
//


    override fun getItemCount(): Int = list.size
}