package com.projectku.ecommercefirebase.activity

import android.Manifest
import android.content.SharedPreferences
import android.content.pm.PackageManager
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.widget.Toast
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import com.google.firebase.auth.FirebaseAuth
import com.google.firebase.firestore.ktx.firestore
import com.google.firebase.ktx.Firebase
import com.midtrans.sdk.corekit.core.MidtransSDK
import com.midtrans.sdk.corekit.core.TransactionRequest
import com.midtrans.sdk.corekit.core.UIKitCustomSetting
import com.midtrans.sdk.corekit.core.themes.CustomColorTheme
import com.midtrans.sdk.corekit.models.BillingAddress
import com.midtrans.sdk.corekit.models.ShippingAddress
import com.midtrans.sdk.uikit.SdkUIFlowBuilder
import com.projectku.ecommercefirebase.databinding.ActivityCheckoutBinding
import com.projectku.ecommercefirebase.utils.MidtransConfig

class CheckoutActivity : AppCompatActivity() {

    private lateinit var binding: ActivityCheckoutBinding
    private lateinit var preferences: SharedPreferences



    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityCheckoutBinding.inflate(layoutInflater)
        setContentView(binding.root)
        preferences = this.getSharedPreferences("user", MODE_PRIVATE)





        binding.button3.setOnClickListener {
            paymentMidtrans()
        }




    }

    private fun paymentMidtrans(){

        val userId = Firebase.firestore.collection("users")
            .document(preferences.getString("number", "")!!)
            .get().addOnSuccessListener { it.getString("userName").toString() }.toString()


        val clientKey: String = MidtransConfig.MERCHANT_CLIENT_KEY
        val baseUrl: String = MidtransConfig.MERCHANT_BASE_CHECKOUT_URL
        val sdkUIFlowBuilder: SdkUIFlowBuilder = SdkUIFlowBuilder.init()
            .setClientKey(clientKey) // client_key is mandatory
            .setContext(this) // context is mandatory
            .setTransactionFinishedCallback{
                this
            } // set transaction finish callback (sdk callback)
            .setMerchantBaseUrl(baseUrl) //set merchant url
            .setUIkitCustomSetting(uiKitCustomSetting())
            .enableLog(true) // enable sdk log
            .setColorTheme(CustomColorTheme("#FFE51255", "#B61548", "#FFE51255")) // will replace theme on snap theme on MAP
            .setLanguage("en")
        sdkUIFlowBuilder.buildSDK()


        val price = intent.getStringExtra("totalCost")

        val transactionRequest = TransactionRequest("Kurbanku-"+System.currentTimeMillis().toString() + "",price!!.toDouble())

        val detail = com.midtrans.sdk.corekit.models.ItemDetails("NamaItem-Id", price.toString().toDouble(),1,"orang")
        val itemDetails = ArrayList<com.midtrans.sdk.corekit.models.ItemDetails>()
        itemDetails.add(detail)
        dataDetail(transactionRequest)
        MidtransSDK.getInstance().transactionRequest = transactionRequest
        MidtransSDK.getInstance().startPaymentUiFlow(this)
    }

    private fun dataDetail(transactionRequest: TransactionRequest){

//
//        val userId = Firebase.firestore.collection("users")
//            .document(preferences.getString("number", "")!!)
//            .get().addOnSuccessListener { it.getString("userName").toString() }.toString()
//
//        val userPhone = Firebase.firestore.collection("users")
//            .document(preferences.getString("number", "")!!)
//            .get().addOnSuccessListener { it.getString("userPhoneNumber").toString() }.toString()
//
//

        val customersDetail = com.midtrans.sdk.corekit.models.CustomerDetails()

        customersDetail.customerIdentifier = "Fauzi"
        customersDetail.phone = "089080980"



        val shippingAddress = ShippingAddress()
        shippingAddress.address = "Jalan pisang rt.02"
       // shippingAddress.city = tempat
        shippingAddress.postalCode = "61264"
        customersDetail.shippingAddress = shippingAddress


        val billingAddress = BillingAddress()
        billingAddress.address = "Jalan pisang rt.02"
//        billingAddress.city = tempat
        billingAddress.postalCode = "61264"
        customersDetail.billingAddress = billingAddress
        transactionRequest.customerDetails = customersDetail


    }

    private fun uiKitCustomSetting(): UIKitCustomSetting {
        val uIKitCustomSetting = UIKitCustomSetting()
        //uIKitCustomSetting.isSkipCustomerDetailsPages = true
        uIKitCustomSetting.isShowPaymentStatus = true
        return uIKitCustomSetting
    }

  







}