package com.projectku.ecommercefirebase.activity

import android.content.Intent
import android.content.SharedPreferences
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.widget.Toast
import com.google.firebase.firestore.ktx.firestore
import com.google.firebase.ktx.Firebase
import com.projectku.ecommercefirebase.databinding.ActivityAddressBinding

class AddressActivity : AppCompatActivity() {

    private lateinit var binding: ActivityAddressBinding
    private lateinit var preferences: SharedPreferences

    private lateinit var totalCost: String

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityAddressBinding.inflate(layoutInflater)
        setContentView(binding.root)
        preferences = this.getSharedPreferences("user", MODE_PRIVATE)


//        val actionBar = supportActionBar
//        actionBar!!.title = "Fill to Address"


        totalCost = intent.getStringExtra("totalCost")!!
        loadInfoUser()

        binding.btnProceed.setOnClickListener {
            validateData(
                binding.userName.text.toString(),
                binding.userNumber.text.toString(),
                binding.village.text.toString(),
                binding.state.text.toString(),
                binding.city.text.toString(),
                binding.pincode.text.toString(),
            )
        }
    }

    private fun validateData(
        number: String,
        name: String,
        village: String,
        state: String,
        pinCode: String,
        city: String
    ) {
        if (number.isEmpty() || state.isEmpty() || name.isEmpty()) {
            Toast.makeText(this, "Please fill all fields", Toast.LENGTH_SHORT).show()
        } else {
            storeData(pinCode, city, state, village)
        }
    }

    private fun storeData(pinCode: String, city: String, state: String, village: String) {
        val map = hashMapOf<String, Any>()
        map["village"] = village
        map["state"] = state
        map["city"] = city
        map["pinCode"] = pinCode

        Firebase.firestore.collection("users")
            .document(preferences.getString("number", "")!!)
            .update(map).addOnSuccessListener {
                val intent = Intent(this, CheckoutActivity::class.java)
                intent.putExtra("productIds", intent.getStringArrayExtra("prodcutsIds"))
                intent.putExtra("totalCost",  totalCost)
                startActivity(intent)
            }
            .addOnFailureListener {
                Toast.makeText(this, "Something went wrong", Toast.LENGTH_SHORT).show()
            }

    }


    private fun loadInfoUser() {

        Firebase.firestore.collection("users")
            .document(preferences.getString("number", "")!!)
            .get().addOnSuccessListener {
                binding.userName.setText(it.getString("userName"))
                binding.userNumber.setText(it.getString("userPhoneNumber"))
                binding.village.setText(it.getString("village"))
                binding.state.setText(it.getString("state"))
                binding.city.setText(it.getString("city"))
                binding.pincode.setText(it.getString("pinCode"))


            }
            .addOnFailureListener {
                Toast.makeText(this@AddressActivity, "Something an error", Toast.LENGTH_SHORT).show()
            }
    }
}