package com.projectku.ecommerceadmin.fragment

import android.content.Intent
import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.navigation.fragment.findNavController
import com.projectku.ecommerceadmin.R
import com.projectku.ecommerceadmin.activity.AllOrderActivity
import com.projectku.ecommerceadmin.databinding.FragmentHomeBinding


class HomeFragment : Fragment() {

    private lateinit var binding: FragmentHomeBinding


    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        binding = FragmentHomeBinding.inflate(layoutInflater)


        binding.apply {
            btnAddcategory.setOnClickListener {
                findNavController().navigate(R.id.action_homeFragment_to_categoryFragment)
            }

            btnAddproduct.setOnClickListener {
                findNavController().navigate(R.id.action_homeFragment_to_productFragment)
            }

            btnAddslider.setOnClickListener {
                findNavController().navigate(R.id.action_homeFragment_to_sliderFragment)
            }

            btnAllorder.setOnClickListener {
                startActivity(Intent(requireContext(), AllOrderActivity::class.java))
            }
        }


        return binding.root
    }


}