package com.projectku.ecommerceadmin.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.projectku.ecommerceadmin.R
import com.projectku.ecommerceadmin.databinding.ItemCategoryBinding
import com.projectku.ecommerceadmin.model.CategoryModel

class CategoryAdapter(var context: Context, val list: ArrayList<CategoryModel>) : RecyclerView.Adapter<CategoryAdapter.ViewHolder>() {

    inner class ViewHolder(view: View): RecyclerView.ViewHolder(view) {
        var binding = ItemCategoryBinding.bind(view)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(LayoutInflater.from(context).inflate(R.layout.item_category, parent ,false))
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.binding.tvProduct?.text = list[position].cat
        Glide.with(context)
            .load(list[position].img)
            .into(holder.binding.imgProduct)
    }

    override fun getItemCount(): Int = list.size

    }


