#define BLYNK_TEMPLATE_ID "TMPL6HgVmBpEK"
#define BLYNK_TEMPLATE_NAME "skripsi"
#define BLYNK_AUTH_TOKEN "A_QsyoJxfEMIu23AFZuiC47zK-GBRycZ"

#include <WiFi.h>
#include <WiFiClient.h>
#include <BlynkSimpleEsp32.h>
#include <DHT.h>
#include <Servo.h>

// Konfigurasi pin dan tipe sensor
#define DHTPIN 4
#define DHTTYPE DHT22
#define SERVOPIN 27

// WiFi dan Blynk
char ssid[] = "Rolex";
char pass[] = "12345678";

// Objek
DHT dht(DHTPIN, DHTTYPE);
Servo myServo;
BlynkTimer timer;

// Mode kontrol
bool manualMode = false;
int manualServoPos = 0;

// Fungsi Blynk: Slider untuk posisi servo manual (V3)
BLYNK_WRITE(V3) {
  manualServoPos = param.asInt();
  if (manualMode) {
    myServo.write(manualServoPos);
    Serial.print("Manual: Servo ke posisi ");
    Serial.println(manualServoPos);
  }
}

// Fungsi Blynk: Switch untuk mengaktifkan mode manual (V4)
BLYNK_WRITE(V4) {
  int mode = param.asInt();
  manualMode = (mode == 1);  // 1 = manual, 0 = otomatis
  if (manualMode) {
    myServo.write(manualServoPos);
    Serial.println("Mode manual AKTIF");
  } else {
    Serial.println("Mode otomatis AKTIF");
  }
}

void setup() {
  Serial.begin(115200);
  Serial.println("Memulai pembacaan sensor DHT22...");

  myServo.attach(SERVOPIN);
  myServo.write(0);
  dht.begin();

  Blynk.begin(BLYNK_AUTH_TOKEN, ssid, pass);

  // Set timer untuk pembacaan suhu dan kontrol servo setiap 2 detik
  timer.setInterval(2000L, bacaSensorDanKirim);
}

void loop() {
  Blynk.run();
  timer.run();
}

void bacaSensorDanKirim() {
  float suhu = dht.readTemperature();
  float kelembaban = dht.readHumidity();

  if (isnan(suhu) || isnan(kelembaban)) {
    Serial.println("Gagal membaca data dari sensor DHT22!");
    return;
  }

  Serial.print("Suhu: ");
  Serial.print(suhu);
  Serial.print(" °C | Kelembaban: ");
  Serial.print(kelembaban);
  Serial.println(" %");

  Blynk.virtualWrite(V0, suhu);
  Blynk.virtualWrite(V1, kelembaban);
  Blynk.virtualWrite(V2, myServo.read());  // Tampilkan posisi servo

  if (!manualMode) {
    int posisiServo;
    if (suhu < 20) {
      posisiServo = 0;
    } else if (suhu <= 23) {
      posisiServo = 45;
       } else if (suhu <= 25) {
      posisiServo = 90;
    } else {
      posisiServo = 90;
    }
    myServo.write(posisiServo);
    Serial.print("Servo (otomatis): ");
    Serial.print(posisiServo);
    Serial.println("°");
  }
}
