    <?php
    session_start(); // Start the session

    // Check if the user is logged in
    if (!isset($_SESSION['username'])) {
        // If not logged in, redirect to the login page
        header("Location: login.php");
        exit();
    }
    ?>

    <!DOCTYPE html>
    <html lang="id">
<head>
    <title>Pengajuan Kredit</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet"/>
    <style>
        body {
            margin: 0;
            font-family: 'Roboto', sans-serif;
            background-color: #f0f0f0;
        }
        .container {
            max-width: 600px;
            margin: 50px auto;
            background-color: #fff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        }
        .header {
            background-color: #1a73e8;
            color: white;
            padding: 15px;
            text-align: center;
            border-radius: 8px 8px 0 0;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        .form-group input, .form-group textarea {
            width: 100%;
            padding: 12px;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
            transition: border-color 0.3s;
        }
        .form-group input:focus, .form-group textarea:focus {
            border-color: #1a73e8;
            outline: none;
        }
        .form-group .required {
            color: red;
        }
        .form-group .submit-btn {
            background-color: #1a73e8;
            color: #fff;
            padding: 12px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            width: 100%;
            transition: background-color 0.3s;
        }
        .form-group .submit-btn:hover {
            background-color: #0056b3;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 14px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Pengajuan Kredit</h1>
        </div>
        <p>Dengan ini saya mengajukan permohonan program pengajuan kredit</p>
        <form action="process_pengajuan.php" method="POST" enctype="multipart/form-data">
            <div class="form-group">
                <label for="nama">Nama lengkap <span class="required">*</span></label>
                <input id="nama" name="nama" placeholder="Isi nama lengkap" type="text" required/>
            </div>
            <div class="form-group">
                <label for="ktp">No. KTP <span class="required">*</span></label>
                <input id="ktp" name="ktp" placeholder="Isi nomor KTP" type="text" required/>
            </div>
            <div class="form-group">
                <label for="alamat">Alamat Lengkap <span class="required">*</span></label>
                <textarea id="alamat" name="alamat" placeholder="Masukan alamat lengkap" required></textarea>
            </div>
            <div class="form-group">
                <label for="kodepos">Kode Pos <span class="required">*</span></label>
                <input id="kodepos" name="kodepos" placeholder="Masukan nomor kodepos" type="text" required/>
            </div>
            <div class="form-group">
                <label for="telp">No. Telp / HP <span class="required">*</span></label>
                <input id="telp" name="telp" placeholder="Masukan nomor handphone" type="text" required/>
            </div>
            <div class="form-group">
                <label for="nominal">Nominal Pinjaman <span class="required">*</span></label>
                <input id="nominal" name="nominal" placeholder="Masukan nominal pinjaman" type="number" step="0.01" required/>
            </div>
            <div class="form-group">
                <label for="upload">Upload Dokumen <span class="required">*</span></label>
                <input id="upload" name="upload" type="file" required/>
            </div>
            <div class="form-group">
                <label for="syarat">Setuju dengan syarat dan ketentuan <span class="required">*</span></label>
                <div class="checkbox-label">
                    <input type="checkbox" id="syarat" name="syarat" required/>
                    <label for="syarat">Saya setuju</label>
                </div>
            </div>
            <div class="form-group">
                <button type="submit" class="submit-btn">Kirim Pengajuan</button>
            </div>
        </form>
        <div class="footer">
            <p>Copyright © 2024</p>
        </div>
    </div>
</body>
</html>