<?php
session_start(); // Memulai sesi untuk membaca data login
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengajuan Kredit</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet"/>
    <style>
        body {
            margin: 0;
            font-family: 'Roboto', sans-serif;
            background-color: #eef2f3;
        }
        .header {
            background-color: #1a73e8;
            padding: 15px 30px;
            display: flex;
            align-items: center;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
        }
        .header img {
            height: 50px;
            margin-right: 20px;
        }
        .header nav {
            flex: 1;
            display: flex;
            justify-content: center;
        }
        .header nav a {
            color: white;
            margin: 0 15px;
            text-decoration: none;
            font-weight: 700;
            transition: all 0.3s ease;
            position: relative;
        }
        .header nav a::after {
            content: '';
            display: block;
            height: 3px;
            width: 0;
            background: #ffcc00;
            transition: width 0.3s;
            position: absolute;
            bottom: -5px;
            left: 50%;
            transform: translateX(-50%);
        }
        .header nav a:hover::after {
            width: 100%;
        }
        .user-info {
            display: flex;
            align-items: center;
        }
        .user-name {
            color: white;
            font-weight: bold;
            margin-right: 15px;
        }
        .login, .logout {
            background-color: #ffcc00;
            color: #1a73e8;
            padding: 10px 20px;
            border-radius: 5px;
            text-decoration: none;
            font-weight: 700;
            transition: background 0.3s;
        }
        .login:hover, .logout:hover {
            background-color: #e0b800;
        }
        .main {
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 80px 20px;
            text-align: center;
            background: linear-gradient(135deg, #1a73e8, #4fc3f7);
            color: white;
            box-shadow: 0px 10px 20px rgba(0, 0, 0, 0.1);
        }
        .content {
            max-width: 600px;
        }
        .content h1 {
            font-size: 36px;
            margin-bottom: 20px;
        }
        .content button {
            background: #ffcc00;
            border: none;
            padding: 15px 30px;
            font-size: 18px;
            font-weight: bold;
            color: #1a73e8;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
        }
        .content button:hover {
            background: #e0b800;
            transform: translateY(-3px);
        }
        .image img {
            max-width: 100%;
            height: auto;
            margin-top: 20px;
        }
        .footer {
            background: #1a73e8;
            color: white;
            text-align: center;
            padding: 20px;
            margin-top: 50px;
            font-size: 14px;
            box-shadow: 0px -4px 10px rgba(0, 0, 0, 0.1);
        }
        @media (max-width: 768px) {
            .main {
                flex-direction: column;
                text-align: center;
            }
            .content h1 {
                font-size: 28px;
            }
            .content button {
                padding: 12px 25px;
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <header class="header">
        <img src="https://storage.googleapis.com/a1aa/image/sqIMeZuanK2rPiaWWt7Vu8jK20ROJtkokGJC5DnFX4PlhTeTA.jpg" alt="Bank Jateng Logo">
        <nav>
            <a href="index.php">Home</a>
            <a href="pengajuan.php">Pengajuan Kredit</a>
            <a href="riwayat.php">Riwayat Pengajuan</a>
            <div class="user-info">
                <?php if (isset($_SESSION['username'])): ?>
                    <span class="user-name"><?php echo htmlspecialchars($_SESSION['username']); ?></span>
                    <a href="logout.php" class="logout">Logout</a>
                <?php else: ?>
                    <a href="login.php" class="login">Login</a>
                <?php endif; ?>
            </div>
        </nav>
    </header>
    <main class="main">
        <div class="content">
            <h1>Ajukan Kredit dengan Mudah</h1>
            <a href="pengajuan.php"><button>Ajukan Sekarang</button></a> 
        </div>
        <div class="image">
            <img src="image/ilustrasi.png" alt="Illustration of a laptop with financial documents and coins">
        </div>
    </main>
    <footer class="footer">
        <p>Copyright © 2024 | Semua Hak Dilindungi</p>
    </footer>
</body>
</html>
