<?php
// Koneksi ke database
$servername = "localhost"; // Ganti jika perlu
$username = "root"; // Ganti jika perlu
$password = ""; // Ganti jika perlu
$dbname = "bprkredit"; // Nama database yang telah dibuat

// Membuat koneksi
$conn = new mysqli($servername, $username, $password, $dbname);

// Cek koneksi
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Ambil data berdasarkan ID
$id = $_GET['id'];
$sql = "SELECT * FROM pengajuan WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Pengajuan</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f2f2f2;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 400px;
        }
        h1 {
            text-align: center;
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 5px;
        }
        input[type="text"],
        input[type="file"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        input[type="submit"] {
            background-color: #28a745;
            color: white;
            border: none;
            padding: 10px;
            border-radius: 4px;
            cursor: pointer;
            width: 100%;
        }
        input[type="submit"]:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Edit Pengajuan</h1>
        <form action="update_pengajuan.php" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
            <label>Nama:</label>
            <input type="text" name="nama" value="<?php echo $row['nama']; ?>" required>
            <label>No. KTP:</label>
            <input type="text" name="ktp" value="<?php echo $row['ktp']; ?>" required>
            <label>Alamat:</label>
            <input type="text" name="alamat" value="<?php echo $row['alamat']; ?>" required>
            <label>Kode Pos:</label>
            <input type="text" name="kodepos" value="<?php echo $row['kodepos']; ?>" required>
            <label>No. Telp:</label>
            <input type="text" name="telp" value="<?php echo $row['telp']; ?>" required>
            <label>Nominal:</label>
            <input type="text" name="nominal" value="<?php echo $row['nominal']; ?>" required>
            <label>Upload File:</label>
            <input type="file" name="upload">
            <input type="submit" value="Update Pengajuan">
        </form>
    </div>
</body>
</html>

<?php
// Menutup koneksi
$stmt->close();
$conn->close();
?>