<?php
session_start();
if (!isset($_SESSION['admin_username'])) {
    header("Location: admin_login.php");
    exit();
}

// Koneksi ke database
$servername = "localhost"; // Ganti jika perlu
$username = "root"; // Ganti jika perlu
$password = ""; // Ganti jika perlu
$dbname = "bprkredit"; // Nama database yang telah dibuat

// Membuat koneksi
$conn = new mysqli($servername, $username, $password, $dbname);

// Cek koneksi
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Mengambil data pengajuan
$sql = "SELECT * FROM pengajuan";
$result = $conn->query($sql);

// Cek jika ada permintaan AJAX
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Mengambil ID dan aksi dari permintaan AJAX
    $id = $_POST['id'];
    $action = $_POST['action'];

    // Memperbarui status pengajuan
    if ($action == 'accept') {
        $sql = "UPDATE pengajuan SET status = 'Diterima' WHERE id = ?";
    } else {
        $sql = "UPDATE pengajuan SET status = 'Ditolak' WHERE id = ?";
    }

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => $action == 'accept' ? 'Pengajuan diterima!' : 'Pengajuan ditolak!']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Terjadi kesalahan, coba lagi.']);
    }

    // Menutup koneksi
    $stmt->close();
    $conn->close();
    exit; // Menghentikan eksekusi script setelah menangani AJAX
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - Validasi Pengajuan Kredit</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet"/>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet"/>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 90%;
            margin: 20px auto;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }
        .header {
            background: linear-gradient(45deg, #ffeb3b, #fbc02d);
            padding: 15px;
            text-align: center;
            border-radius: 8px 8px 0 0;
            color: #333;
        }
        .logout {
            text-align: right;
            margin: 10px 0;
        }
        .logout a {
            text-decoration: none;
            color: #dc3545;
            font-weight: bold;
            transition: 0.3s;
        }
        .logout a:hover {
            color: #b71c1c;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #f1f1f1;
        }
        tbody tr:hover {
            background-color: #f8f9fa;
            transition: 0.3s;
        }
        .btn-accept, .btn-reject {
            padding: 8px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            transition: 0.3s;
        }
        .btn-accept {
            background: #28a745;
            color: white;
        }
        .btn-accept:hover {
            background: #218838;
        }
        .btn-reject {
            background: #dc3545;
            color: white;
        }
        .btn-reject:hover {
            background: #c82333;
        }
        .notification {
            display: none;
            padding: 10px;
            margin: 10px 0;
            border-radius: 4px;
            text-align: center;
            color: white;
            font-weight: bold;
        }
        .notification.success {
            background: #28a745;
        }
        .notification.error {
            background: #dc3545;
        }
        @media (max-width: 768px) {
            .container {
                width: 95%;
            }
            table {
                font-size: 14px;
            }
            .btn-accept, .btn-reject {
                font-size: 12px;
                padding: 5px 10px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Dashboard Admin - Validasi Pengajuan Kredit</h1>
        </div>
        <div class="logout">
            <a href="admin_logout.php">Logout</a>
        </div>
        <div id="notification" class="notification"></div>
        <table>
            <thead>
                <tr>
                    <th>Nama Lengkap</th>
                    <th>No. KTP</th>
                    <th>Nominal Pinjaman</th>
                    <th>Alamat</th>
                    <th>Telepon</th>
                    <th>kodepos</th>
                    <th>upload</th>
                    <th>Status</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result->num_rows > 0): ?>
                    <?php while($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $row['nama']; ?></td>
                            <td><?php echo $row['ktp']; ?></td>
                            <td><?php echo $row['nominal']; ?></td>
                            <td><?php echo $row['alamat']; ?></td>
                            <td><?php echo $row['telp']; ?></td>
                            <td><?php echo $row['kodepos']; ?></td>
                            <td><a href="<?php echo $row['upload']; ?>" target="_blank">Lihat</a></td>
                            <td><span style="color: orange;"><?php echo $row['status'] ?? 'Menunggu'; ?></span></td>
                            <td>
                                <button class="btn-accept" onclick="updateStatus(<?php echo $row['id']; ?>, 'accept')">Terima</button>
                                <button class="btn-reject" onclick="updateStatus(<?php echo $row['id']; ?>, 'reject')">Tolak</button>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="9" style="text-align:center;">Tidak ada pengajuan yang ditemukan.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <script>
        function showNotification(message, isSuccess) {
            var notification = document.getElementById('notification');
            notification.textContent = message;
            notification.classList.toggle('success', isSuccess);
            notification.classList.toggle('error', !isSuccess);
            notification.style.display = 'block';
            setTimeout(function() {
                notification.style.display = 'none';
                notification.classList.remove('success', 'error');
            }, 3000);
        }

        function updateStatus(id, action) {
            var xhr = new XMLHttpRequest();
            xhr.open("POST", "", true); // Mengirim ke halaman yang sama
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    var response = JSON.parse(xhr.responseText);
                    if (response.success) {
                        showNotification(response.message, true);
                    } else {
                        showNotification(response.message, false);
                    }
                }
            };
            xhr.send("id=" + id + "&action=" + action);
        }
    </script>
</body>
</html>

<?php
// Menutup koneksi
$conn->close();
?>