<?php
require 'function.php';
session_start();
//require 'cek.php';
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="author" content="" />
    <title>Dashboard - SPRINT</title>
    <link href="css/styles.css" rel="stylesheet" />
    <link href="https://cdn.datatables.net/1.10.20/css/dataTables.bootstrap4.min.css" rel="stylesheet" crossorigin="anonymous" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/js/all.min.js" crossorigin="anonymous"></script>
</head>

<body class="sb-nav-fixed">
    <nav class="sb-topnav navbar navbar-expand navbar-dark bg-dark">
        <a class="navbar-brand" href="index.php">POLRES MOJOKERTO</a>
        <button class="btn btn-link btn-sm order-1 order-lg-0" id="sidebarToggle" href="#"><i class="fas fa-bars"></i></button>
        <!-- Navbar Search-->
        <form class="d-none d-md-inline-block form-inline ml-auto mr-0 mr-md-3 my-2 my-md-0">

        </form>
        <!-- Navbar-->
        <ul class="navbar-nav ml-auto ml-md-0">
            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" id="userDropdown" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-user fa-fw"></i></a>
                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="userDropdown">
                    <a class="dropdown-item" href="logout.php">Masuk sebagai User</a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="logout.php">Logout</a>
                </div>
            </li>
        </ul>
    </nav>
    <div id="layoutSidenav">
        <div id="layoutSidenav_nav">
            <nav class="sb-sidenav accordion sb-sidenav-dark" id="sidenavAccordion">
                <div class="sb-sidenav-menu">
                    <div class="nav">
                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="dashboard.php">
                            <div class="sb-nav-link-icon"><i class="fa fa-th"></i></div>
                            Dashboard
                        </a>
                        <a class="nav-link" href="anggota.php">
                            <div class="sb-nav-link-icon"><i class="fa fa-users"></i></div>
                            Anggota
                        </a>
                        <a class="nav-link" href="sprint.php">
                            <div class="sb-nav-link-icon"><i class="fa fa-file"></i></div>
                            SPRINT
                        </a>
                        <a class="nav-link" href="jadwal.php">
                            <div class="sb-nav-link-icon"><i class="fa fa-calendar"></i></div>
                            Jadwal
                        </a>
                        <a class="nav-link" href="rute.php">
                            <div class="sb-nav-link-icon"><i class="fa fa-road"></i></div>
                            Rute
                        </a>
                    </div>
                </div>
                <div class="sb-sidenav-footer">
                    <div class="small">Logged in :</div>
                    <?php echo $_SESSION['iden']; ?> as <?php echo $_SESSION['role']; ?>
                </div>
            </nav>
        </div>
        <div id="layoutSidenav_content">
            <main>
                <div class="container-fluid">
                    <h1 class="mt-4">Surat Perintah</h1>

                    <div class="card mb-4">
                        <div class="card-header">
                            <!-- Button to Open the Modal -->
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#myModal">
                                Tambah
                            </button>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>NO</th>
                                            <th>Nama File</th>
                                            <th>Tampilan</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $no = 0;
                                        $ambilsemua = mysqli_query($conn, "SELECT * FROM sprint");
                                        while ($spt = mysqli_fetch_array($ambilsemua)) {
                                            $nama = $spt['nama'];
                                            $foto = $spt['foto'];
                                            $ids = $spt['id'];
                                            $no++
                                        ?>
                                            <tr>
                                                <td width='5%'><?php echo $no; ?></td>
                                                <td width='25%'><?php echo $nama; ?></td>
                                                <td><img src="img/<?php echo $foto; ?>" style="width: 100px;"></td>
                                                <td><button type="button" class="btn btn-success" data-toggle="modal" data-target="#editsprint<?= $ids; ?>">
                                                        <i class="fa fa-eye" aria-hidden="true"></i>
                                                        Lihat
                                                    </button>
                                                    <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deletesprint<?= $ids; ?>">
                                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                                        hapus
                                                    </button>
                                                </td>
                                            </tr>

                                            <!--edit modal -->
                                            <div class="modal fade" id="editsprint<?= $ids; ?>">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">

                                                        <!-- Modal Header -->
                                                        <div class="modal-header modal-xl">
                                                            <h4 class="modal-title">Surat Perintah</h4>
                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                        </div>

                                                        <!-- Modal body -->
                                                        <div class="modal-body modal-xl">
                                                            <img src="img/<?php echo $foto; ?>" style="height: 700px; width: 470px;" alt="">
                                                        </div>

                                                        <!-- Modal footer -->
                                                        <div class="modal-footer modal-xl">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--edit-->

                                            <!-- Delete Modal -->
                                            <div class="modal fade" id="deletesprint<?= $ids; ?>">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">

                                                        <!-- Modal Header -->
                                                        <div class="modal-header">
                                                            <h4 class="modal-title">Delete Data</h4>
                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                        </div>

                                                        <!-- Modal body -->
                                                        <div class="modal-body">
                                                            <form method="post">
                                                                <h3 align="center">yakin nih mau hapus data ? <br>
                                                                    <span class="text-warning"><?php echo $spt['nama']; ?> !!! </span>
                                                                </h3>

                                                                <br>
                                                                <br>
                                                                <input type="hidden" name="ids" value="<?= $ids; ?>">
                                                                <button type="submit" class="btn btn-danger" name="hapussprint">hapus</button>
                                                            </form>
                                                        </div>

                                                        <!-- Modal footer -->
                                                        <div class="modal-footer">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- delete -->

                                        <?php
                                        };
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
            <footer class="py-4 bg-light mt-auto">
                <div class="container-fluid">
                    <div class="d-flex align-items-center justify-content-between small">
                        <div class="text-muted">Copyright &copy; <a href="https://mokerkab.jatim.polri.go.id/polres-mojokerto/">POLRES MOJOKERTO</a></div>

                    </div>
                </div>
            </footer>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
    <script src="js/scripts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
    <script src="assets/demo/chart-area-demo.js"></script>
    <script src="assets/demo/chart-bar-demo.js"></script>
    <script src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.datatables.net/1.10.20/js/dataTables.bootstrap4.min.js" crossorigin="anonymous"></script>
    <script src="assets/demo/datatables-demo.js"></script>
</body>
<div class="modal fade" id="myModal">
    <div class="modal-dialog">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Tambah Data</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <form method="post" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label for="nama" class="form-label">Nama File</label>
                        <input type="text" name="nama" class="form-control" id="nama" placeholder="Masukan nama" required>
                    </div>
                    <div class="mb-3">
                        <label for="foto" class="form-label">Upload File</label>
                        <input class="form-control" type="file" id="foto" name="foto" required>
                    </div>
                    <button type="submit" class="btn btn-info" name="addsprint">Submit</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                </form>
            </div>

            <!-- Modal footer -->
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>

</html>