<?php
require 'function.php';
session_start();
//require 'cek.php';
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="author" content="" />
    <title>Dashboard - Rute</title>
    <link href="css/styles.css" rel="stylesheet" />
    <link href="https://cdn.datatables.net/1.10.20/css/dataTables.bootstrap4.min.css" rel="stylesheet" crossorigin="anonymous" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/js/all.min.js" crossorigin="anonymous"></script>
</head>

<body class="sb-nav-fixed">
    <nav class="sb-topnav navbar navbar-expand navbar-dark bg-dark">
        <a class="navbar-brand" href="index.php">POLRES MOJOKERTO</a>
        <button class="btn btn-link btn-sm order-1 order-lg-0" id="sidebarToggle" href="#"><i class="fas fa-bars"></i></button>
        <!-- Navbar Search-->
        <form class="d-none d-md-inline-block form-inline ml-auto mr-0 mr-md-3 my-2 my-md-0">

        </form>
        <!-- Navbar-->
        <ul class="navbar-nav ml-auto ml-md-0">
            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" id="userDropdown" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-user fa-fw"></i></a>
                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="userDropdown">
                    <a class="dropdown-item" href="logout.php">Masuk sebagai User</a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="logout.php">Logout</a>
                </div>
            </li>
        </ul>
    </nav>
    <div id="layoutSidenav">
        <div id="layoutSidenav_nav">
            <nav class="sb-sidenav accordion sb-sidenav-dark" id="sidenavAccordion">
                <div class="sb-sidenav-menu">
                    <div class="nav">
                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="dashboard.php">
                            <div class="sb-nav-link-icon"><i class="fa fa-th"></i></div>
                            Dashboard
                        </a>
                        <a class="nav-link" href="anggota.php">
                            <div class="sb-nav-link-icon"><i class="fa fa-users"></i></div>
                            Anggota
                        </a>
                        <a class="nav-link" href="sprint.php">
                            <div class="sb-nav-link-icon"><i class="fa fa-file"></i></div>
                            SPRINT
                        </a>
                        <a class="nav-link" href="jadwal.php">
                            <div class="sb-nav-link-icon"><i class="fa fa-calendar"></i></div>
                            Jadwal
                        </a>
                        <a class="nav-link" href="rute.php">
                            <div class="sb-nav-link-icon"><i class="fa fa-road"></i></div>
                            Rute
                        </a>
                    </div>
                </div>
                <div class="sb-sidenav-footer">
                    <div class="small">Logged in :</div>
                    <?php echo $_SESSION['iden']; ?> as <?php echo $_SESSION['role']; ?>
                </div>
            </nav>
        </div>
        <div id="layoutSidenav_content">
            <main>
                <div class="container-fluid">
                    <h1 class="mt-4">Rute</h1>

                    <div class="card mb-4">
                        <div class="card-header">
                            <!-- Button to Open the Modal -->
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#myModal">
                                <i class="fa fa-plus-circle" aria-hidden="true"></i>
                                Tambah
                            </button>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead align="center">
                                        <tr>
                                            <th>No.</th>
                                            <th>Nama</th>
                                            <th>Tanggal</th>
                                            <th>Jam Piket</th>
                                            <th>Wilayah</th>
                                            <th>Kehadiran</th>
                                            <th>Aksi</th>
                                            <!-- <th style="width: 5rem;">No.</th>
                                            <th style="width: 8rem;">Nama</th>
                                            <th style="width: 8rem;">Tanggal</th>
                                            <th style="width: 8rem;">Jam Piket</th>
                                            <th style="width: 15rem;">Wilayah</th>
                                            <th style="width: 10rem;">Kehadiran</th>
                                            <th style="width: 8rem;">Aksi</th> -->
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $no = 0;
                                        $ambilsemua = mysqli_query($conn, "SELECT * FROM rute");
                                        while ($rt = mysqli_fetch_array($ambilsemua)) {
                                            $nama = $rt['nama'];
                                            $namaa1 = $rt['namaa1'];
                                            $namaa2 = $rt['namaa2'];
                                            $namaa3 = $rt['namaa3'];
                                            $tanggal = $rt['tanggal'];
                                            $jam = $rt['jam'];
                                            $wilayah = $rt['wilayah'];
                                            $foto = $rt['foto'];
                                            $idr = $rt['id'];
                                            $no++
                                        ?>
                                            <tr>
                                                <td width='5%'><?php echo $no; ?></td>
                                                <td><?php echo $rt['nama']; ?><br><?php echo $rt['namaa1']; ?><br><?php echo $rt['namaa2']; ?><br><?php echo $rt['namaa3']; ?></td>
                                                <td><?= date('d-m-Y', strtotime($rt['tanggal'])); ?></td>
                                                <td><?= date('H:i', strtotime($rt['jam'])); ?> - <?= date('H:i', strtotime($rt['waktu'])); ?></td>
                                                <td><?php echo $rt['wilayah']; ?></td>
                                                <td><img src="imguser/<?php echo $rt['foto']; ?>" style="width: 200px;" alt=""></td>
                                                <td>
                                                    <button type="button" class="btn btn-success" data-toggle="modal" data-target="#edit<?= $idr; ?>">
                                                        <i class="fa fa-undo" aria-hidden="true"></i>
                                                        Edit
                                                    </button>
                                                    <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#delete<?= $idr; ?>">
                                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                                        hapus
                                                    </button>
                                                    <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#lihathadir<?= $idr; ?>">
                                                        <i class="fa fa-eye" aria-hidden="true"></i>
                                                        Lihat
                                                    </button>
                                                </td>
                                            </tr>

                                            <!-- edit Modal -->
                                            <div class="modal fade" id="edit<?= $idr; ?>">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">

                                                        <!-- Modal Header -->
                                                        <div class="modal-header">
                                                            <h4 class="modal-title">Tambah Data</h4>
                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                        </div>

                                                        <!-- Modal body -->
                                                        <div class="modal-body">
                                                            <form method="post">
                                                                <div class="mb-3">
                                                                    <label for="nama" class="form-label">Nama</label>
                                                                    <input type="text" name="nama" class="form-control" id="nama" value="<?php echo $rt['nama']; ?>" required>
                                                                    <input type="text" name="namaa1" class="form-control" id="namaa1" value="<?php echo $rt['namaa1']; ?>" required>
                                                                    <input type="text" name="namaa2" class="form-control" id="namaa2" value="<?php echo $rt['namaa2']; ?>" required>
                                                                    <input type="text" name="namaa3" class="form-control" id="namaa3" value="<?php echo $rt['namaa3']; ?>" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="tanggal" class="form-label">Tanggal</label>
                                                                    <input type="date" name="tanggal" class="form-control" id="tanggal" value="<?php echo $rt['tanggal']; ?>" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="jam" class="form-label">Jam Piket</label>
                                                                    <input type="time" name="jam" class="form-control" id="jam" value="<?php echo $rt['jam']; ?>" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="waktu" class="form-label">Jam Piket Berakhir</label>
                                                                    <input type="time" name="waktu" class="form-control" id="waktu" value="<?php echo $rt['waktu']; ?>" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="wilayah" class="form-label">wilayah</label>
                                                                    <input type="text" name="wilayah" class="form-control" id="wilayah" value="<?php echo $rt['wilayah']; ?>" required>
                                                                </div>
                                                                <input type="hidden" name="idr" value="<?= $idr; ?>">
                                                                <button type="submit" class="btn btn-info" name="updaterute">Submit</button>
                                                                <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                                            </form>
                                                        </div>

                                                        <!-- Modal footer -->
                                                        <div class="modal-footer">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- edit-->

                                            <!-- Delete Modal -->
                                            <div class="modal fade" id="delete<?= $idr; ?>">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">

                                                        <!-- Modal Header -->
                                                        <div class="modal-header">
                                                            <h4 class="modal-title">Delete Data</h4>
                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                        </div>

                                                        <!-- Modal body -->
                                                        <div class="modal-body">
                                                            <form method="post">
                                                                <h3 align="center">apakah anda yakin mau hapus data<br>
                                                                    <span class="text-danger"><?php echo $rt['nama']; ?></span> ?
                                                                </h3>
                                                                <br>
                                                                <br>
                                                                <input type="hidden" name="idr" value="<?= $idr; ?>">
                                                                <button type="submit" class="btn btn-danger" name="hapusrute">hapus</button>
                                                            </form>
                                                        </div>

                                                        <!-- Modal footer -->
                                                        <div class="modal-footer">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- delete -->

                                            <!--lihat modal -->
                                            <div class="modal fade" id="lihathadir<?= $idr; ?>">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">

                                                        <!-- Modal Header -->
                                                        <div class="modal-header modal-xl">
                                                            <h4 class="modal-title">Hasil Kehadiran</h4>
                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                        </div>

                                                        <!-- Modal body -->
                                                        <div class="modal-body modal-xl">
                                                            <img src="imguser/<?php echo $foto; ?>" style="height: 300px; width: 470px;" alt="">
                                                        </div>

                                                        <!-- Modal footer -->
                                                        <div class="modal-footer modal-xl">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--lihat-->

                                        <?php
                                        };
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
            <footer class="py-4 bg-light mt-auto">
                <div class="container-fluid">
                    <div class="d-flex align-items-center justify-content-between small">
                        <div class="text-muted">Copyright &copy; <a href="https://mokerkab.jatim.polri.go.id/polres-mojokerto/">POLRES MOJOKERTO</a></div>

                    </div>
                </div>
            </footer>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
    <script src="js/scripts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
    <script src="assets/demo/chart-area-demo.js"></script>
    <script src="assets/demo/chart-bar-demo.js"></script>
    <script src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.datatables.net/1.10.20/js/dataTables.bootstrap4.min.js" crossorigin="anonymous"></script>
    <script src="assets/demo/datatables-demo.js"></script>
</body>


<!-- The Modal tambah anggota -->
<div class="modal fade" id="myModal">
    <div class="modal-dialog">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Tambah Data</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <form method="post">
                    <div class="mb-3">
                        <label for="nama" class="form-label">Nama</label>
                        <input type="text" name="nama" class="form-control" id="nama" placeholder="Masukan Nama Anggota 1" required><br>
                        <input type="text" name="namaa1" class="form-control" id="namaa1" placeholder="Masukan Nama Anggota 2" required><br>
                        <input type="text" name="namaa2" class="form-control" id="namaa2" placeholder="Masukan Nama Anggota 3" required><br>
                        <input type="text" name="namaa3" class="form-control" id="namaa3" placeholder="Masukan Nama Anggota 4" required>
                    </div>
                    <div class="mb-3">
                        <label for="tanggal" class="form-label">Tanggal</label>
                        <input type="date" name="tanggal" class="form-control" id="tanggal" placeholder="tanggal" required>
                    </div>
                    <div class="mb-3">
                        <label for="jam" class="form-label">Jam Piket</label>
                        <input type="time" name="jam" class="form-control" id="jam" placeholder="jam" required>
                    </div>
                    <div class="mb-3">
                        <label for="waktu" class="form-label">Jam Piket Berakhir</label>
                        <input type="time" name="waktu" class="form-control" id="waktu" placeholder="waktu" required>
                    </div>
                    <div class="mb-3">
                        <label for="wilayah" class="form-label">wilayah</label>
                        <input type="text" name="wilayah" class="form-control" id="wilayah" placeholder="Masukan wilayah" required>
                    </div>
                    <button type="submit" class="btn btn-info" name="addrute">Submit</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                </form>
            </div>

            <!-- Modal footer -->
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>

</html>