<?php

include('../_partials/top.php');

include('data-show.php');

if (isset($_POST['btn_simpan'])) {
  $id_warga = $_POST['id_warga'];
  $nik_warga = $_POST['nik_warga'];
  $keterangan = $_POST['keterangan'];
  $id_user = $_SESSION['user']['id_user'];

  $base_dir = "uploads/";
  // Path folder berdasarkan nomor pesanan
  $target_dir = $base_dir . $nik_warga . "/";

  // Cek apakah folder sudah ada, jika belum buat folder
  if (!is_dir($target_dir)) {
    mkdir($target_dir, 0777, true); // 0777 memberikan izin penuh
  }

  // File yang diunggah
  $file_name = $_FILES['berkas']['name'];
  $file_tmp = $_FILES['berkas']['tmp_name'];
  $file_size = $_FILES['berkas']['size'];

  // Path lengkap tempat menyimpan file
  $target_file = $target_dir . basename($file_name);
  
  // Validasi tipe file
  $allowed_extensions = ['jpg', 'jpeg', 'png'];
  $file_extension = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
  if (!in_array($file_extension, $allowed_extensions)) {
    die("Format file tidak diizinkan.");
  }

  // Validasi ukuran file (maksimal 2MB)
    if ($file_size > 2097152) {
      die("Ukuran file terlalu besar. Maksimal 2MB.");
    }

  // Proses upload file
  if (move_uploaded_file($file_tmp, $target_file)) {
    $query = "INSERT INTO warga_berkas (id_warga, nik_warga, file, keterangan, id_user) VALUES ('$id_warga', '$nik_warga', '$file_name', '$keterangan', '$id_user')";
    $hasil = mysqli_query($db, $query);
  } else {
    echo "Terjadi kesalahan saat mengunggah file.";
  }
}

if (isset($_POST['btn_hapus'])) {
  $id = $_POST['id'];

  $sql = "SELECT file, nik_warga FROM warga_berkas WHERE id_berkas_warga = $id";
  $result = $db->query($sql);

  // Cek jika data ditemukan
  if ($result->num_rows > 0) {
    // Ambil data file path dan no_nota dari hasil query
    $row = $result->fetch_assoc();
    $file_name = $row['file'];
    $nik_warga = $row['nik_warga'];

    // Tentukan path lengkap file
    $file_path = "uploads/" . $nik_warga . "/" . $file_name;

    // Hapus file jika ada
    if (file_exists($file_path)) {
      unlink($file_path);  // Menghapus file
    }

    // Query untuk menghapus data dari database
    $delete_sql = "DELETE FROM warga_berkas WHERE id_berkas_warga = $id";
    if ($db->query($delete_sql) === TRUE) {
      //berhasil
    } else {
      echo "Terjadi kesalahan saat menghapus data dari database.";
    }
  } else {
    echo "Data tidak ditemukan.";
  }
}

if (isset($_GET['file'])) {
  $file = 'uploads/' . basename($_GET['file']); // Pastikan nama file aman
  if (file_exists($file)) {
    header('Content-Description: File Transfer');
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="' . basename($file) . '"');
    header('Content-Length: ' . filesize($file));
    readfile($file);
    exit;
  } else {
    echo "File tidak ditemukan.";
  }
}

?>

<h1 class="page-header">Data Warga : <?= $data_warga[0]['nama_warga'] ?></h1>
<?php include('_partials/menu.php') ?>
<button type="button" class="btn btn-info btn-sm" onclick="javascript:history.back()">
  <i class="fa fa-arrow-circle-left"></i> Kembali
</button>
<form action="" method="post" enctype="multipart/form-data">
  <h3>Upload Berkas</h3>
  <table class="table table-striped table-middle">
    <tr>
      <th width="20%">ID</th>
      <td width="1%">:</td>
      <td><input type="text" class="form-control" name="id_warga" value="<?= $get_id_warga ?>" readonly></td>
    </tr>
    <tr>
      <th width="20%">NIK Warga</th>
      <td width="1%">:</td>
      <td><input type="text" class="form-control" name="nik_warga" value="<?= $data_warga[0]['nik_warga'] ?>" readonly></td>
    </tr>
    <tr>
      <th width="20%">Upload Berkas <span> (ukuran max : 2MB)</span></th>
      <td width="1%">:</td>
      <td><input type="file" class="form-control" name="berkas" required></td>
    </tr>
    <tr>
      <th>Keterangan</th>
      <td>:</td>
      <td><input type="text" class="form-control" name="keterangan" required></td>
    </tr>
  </table>
  <button type="submit" class="btn btn-success" name="btn_simpan">
    <i class="fa fa-save"></i> Simpan
  </button>
  <button type="button" class="btn btn-danger" onclick="javascript:history.back();">
    <i class="fa fa-arrow-circle-left"></i> Batal
  </button>
</form>

<hr>

<table class="table table-striped table-condensed table-hover" id="datatable">
  <thead>
    <tr>
      <th>#</th>
      <th>File</th>
      <th>Keterangan</th>
      <th>Aksi</th>
    </tr>
  </thead>
  <tbody>
    <?php $nomor = 1; ?>
    <?php
    $sql_data = mysqli_query($db, "SELECT * FROM warga_berkas WHERE id_warga = '$get_id_warga'");
    while ($warga = mysqli_fetch_array($sql_data)) :
    ?>
      <tr>
        <td><?php echo $nomor++ ?>.</td>
        <td><?php echo $warga['file'] ?></td>
        <td><?php echo $warga['keterangan'] ?></td>
        <td>
          <!-- Single button -->
          <div class="btn-group pull-right">
            <button type="button" class="btn btn-default btn-xs dropdown-toggle" data-toggle="dropdown" aria-expanded="true">
              <span class="caret"></span>
            </button>
            <ul class="dropdown-menu pull-right" role="menu">

              <li class="divider"></li>
              <li>
                <a href="uploads/<?= $warga['nik_warga'] ?>/<?= $warga['file'] ?>" target="_blank"><i class="glyphicon glyphicon-sunglasses"></i> Lihat</a>
              </li>
              <li>
                <a href="download.php?nik=<?= $warga['nik_warga'] ?>&file=<?= $warga['file'] ?>" target="_blank"><i class="glyphicon glyphicon-print"></i> Download File</a>
              </li>
              <?php if ($_SESSION['user']['status_user'] != 'RW'): ?>
                <li class="divider"></li>
                <li>
                  <form action="" method="POST">
                    <input type="hidden" name="id" value="<?= $warga['id_berkas_warga']; ?>">
                    <button type="submit" class="btn btn-link" name="btn_hapus" style="color: inherit; text-decoration: none; margin-left:7px;"><i class="glyphicon glyphicon-trash"></i> Hapus</button>
                  </form>
                </li>
                <li class="divider"></li>
              <?php endif; ?>
            </ul>
          </div>
        </td>
      </tr>
    <?php endwhile ?>
  </tbody>
</table>
<?php include('../_partials/bottom.php') ?>