<?php
include 'assets/src/header.php';
require 'assets/src/odbc.php';
?>
<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid px-4">
            <h1 class="mt-4">Data Jilid Santri </h1>
            <ol class="breadcrumb mb-4">
                <li class="breadcrumb-item active">Data Jilid Santri</li>
            </ol>
            <!-- Button trigger modal -->
            <button type="button" class="btn btn-success mb-4" data-bs-toggle="modal" data-bs-target="#tambahSantri">
                Tambahkan Santri
            </button>
            <!-- Modal -->
            <div class="modal fade" id="tambahSantri" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Data Santri</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form action="http://localhost/rapor/assets/src/function.php" method="POST">
                            <div class="modal-body">
                                <div class="mb-3">
                                    <div class="row g-3 align-items-center mb-2">
                                        <div class="col-4">
                                            <label for="" class="col-form-label">NIS</label>
                                        </div>
                                        <div class="col-1">
                                            <label for="" class="col-form-label">:</label>
                                        </div>
                                        <div class="col-7">
                                            <select name="nis" id="" class="form-select">
                                                <?php
                                                $cekNis = "SELECT id, nama FROM santri WHERE status = 'Aktif'";
                                                $stmt_cekNis = $pdo->prepare($cekNis);
                                                $stmt_cekNis->execute();
                                                while ($row = $stmt_cekNis->fetch(PDO::FETCH_ASSOC)) {
                                                ?>
                                                    <option value="<?= $row['id'] ?>"><?= $row['id'] ?> - <?= $row['nama']; ?></option>
                                                <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row g-3 align-items-center mb-2">
                                        <div class="col-4">
                                            <label for="" class="col-form-label">Jilid</label>
                                        </div>
                                        <div class="col-1">
                                            <label for="" class="col-form-label">:</label>
                                        </div>
                                        <div class="col-7">
                                            <select name="jilid" class="form-select">
                                                <option value="">-- Pilih Jilid --</option>
                                                <option value="1">Jilid 1</option>
                                                <option value="2">Jilid 2</option>
                                                <option value="3">Jilid 3</option>
                                                <option value="4">Jilid 4</option>
                                                <option value="5">Jilid 5</option>
                                                <option value="6">Jilid 6</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                <button type="submit" class="btn btn-primary" name="santri_jilid_simpan">Simpan</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="card mb-4">
                <div class="card-header">
                    <div class="text-center">
                        <i class="fas fa-user-graduate me-1"></i>Data Santri
                        <hr>
                    </div>
                    <ul class="nav nav-tabs card-header-tabs" id="myTab" role="tabList">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="semua-tab" data-bs-toggle="tab" data-bs-target="#semua-tab-pane" type="button" role="tab" aria-controls="semua-tab-pane" aria-selected="true" style="width: 20vh;">Semua Santri</button>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="semua-tab-pane" role="tabpanel" aria-labelledby="semua-tab" tabindex="0">
                            <table id="datatablesSimple">
                                <thead>
                                    <tr>
                                        <th>NIS</th>
                                        <th>Nama Santri</th>
                                        <th>Jilid</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = 'SELECT ns.id_santri, s.nama, ns.jilid FROM nilai_santri ns JOIN santri s ON ns.id_santri = s.id';
                                    $stmt = $pdo->query($sql);
                                    $i = 1;

                                    while ($data = $stmt->fetch()) :
                                    ?>
                                        <tr>
                                            <td><?= $data['id_santri']; ?></td>
                                            <td><?= $data['nama']; ?></td>
                                            <td><?= $data['jilid']; ?></td>
                                            <td>
                                                <button type="button" class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#editJilidSantri_<?= $data['id_santri']; ?>">
                                                    <li class="fas fa-gear"></li>
                                                </button>
                                                <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#hapusNilaiSantri_<?= $data['id_santri']; ?>">
                                                    <li class="fas fa-trash"></li>
                                                </button>
                                            </td>

                                            <!-- Modal Edit-->
                                            <div class="modal fade" id="editJilidSantri_<?= $data['id_santri']; ?>" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Input Nilai Santri</h1>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <form action="http://localhost/rapor/assets/src/function.php" method="POST">
                                                            <div class="modal-body">
                                                                <div class="mb-3">
                                                                    <div class="row g-3 align-items-center">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">NIS</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <Label><?= $data['id_santri']; ?></Label>
                                                                            <input type="number" class="form-control" name="nis" value="<?= $data['id_santri']; ?>" hidden>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Nama Santri</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <Label><?= $data['nama']; ?></Label>
                                                                            <input type="text" class="form-control text-uppercase" name="nama" value="<?= $data['nama'] ?>" hidden>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Jilid</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <select name="jilid" class="form-select">
                                                                                <option value="">-- Pilih Jilid --</option>
                                                                                <option value="1">Jilid 1</option>
                                                                                <option value="2">Jilid 2</option>
                                                                                <option value="3">Jilid 3</option>
                                                                                <option value="4">Jilid 4</option>
                                                                                <option value="5">Jilid 5</option>
                                                                                <option value="6">Jilid 6</option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                                <button type="submit" class="btn btn-primary" name="santri_jilid_edit">Simpan</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Modal Hapus -->
                                            <div class="modal fade" id="hapusNilaiSantri_<?= $data['id_santri']; ?>" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Hapus Data Santri</h1>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <form action="http://localhost/rapor/assets/src/function.php" method="POST">
                                                            <div class="modal-body">
                                                                <div class="m-3">
                                                                    <div class="text-center">
                                                                        <input type="text" name="nis" class="form-control" value="<?= $data['id_santri']; ?>" hidden>
                                                                        <input type="text" name="jilid" class="form-control" value="<?= $data['jilid']; ?>" hidden>
                                                                        <label for="">Anda Yakin Ingin Menghapus Data Santri : <?= $data['nama']; ?> | Jilid : <?= $data['jilid']; ?> </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                                <button type="submit" class="btn btn-danger" name="santri_hapus_nilai">Hapus</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </tr>
                                    <?php
                                    endwhile;
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <?php
    include 'assets/src/footer.php';
    ?>