<?php
require('assets/src/odbc.php');
require('assets/lib/fpdf.php');

class PDF extends FPDF
{
    // Header
    function Header()
    {
        $this->SetFont('Arial', 'B', 20);
        $this->Cell(0, 10, "Taman Pendidikan Al-Qur'an AL AMIN", 0, 1, 'C');
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 5, 'Perum Griya Surya Asri Desa Balongdowo Candi-Sidoarjo', 0, 1, 'C');
        $this->Cell(0, 7, 'Telepon: (+62) 1234567', 0, 1, 'C');
        $this->Ln(5);

        $this->Line(10, $this->GetY(), 200, $this->GetY());
        $this->Ln(5);

        $this->SetFont('Arial', 'B', 16);
        $this->Cell(0, 10, 'LAPORAN HASIL BELAJAR SANTRI', 0, 1, 'C');
        $this->Ln(5);
    }

    // Footer
    function Footer()
    {
        // Set posisi Y
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);

        // Nomor halaman di sebelah kiri
        $this->Cell(0, 10, 'Halaman ' . $this->PageNo(), 0, 0, 'L');

        // Posisi untuk tanggal print di sebelah kanan
        $this->SetX(-50); // Geser ke kiri 50 mm dari tepi kanan
        $this->Cell(0, 10, date('d-m-Y'), 0, 0, 'R'); // Tanggal cetak di sebelah kanan
    }

    // Border
    function DrawContentBorder($contentStartY)
    {
        $currentY = $this->GetY();
        $this->Rect(10, $contentStartY, 190, $currentY - $contentStartY);
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id_santri = $_POST['nis'];
    $jilid = $_POST['jilid'];

    $sql = 'SELECT nsr.id_santri, s.nama, nsr.jilid, nsr.tajwid, nsr.makhroj, nsr.tartil, nsr.hafalan, nsr.akhlaq, nsr.total, nsr.rata_rata FROM nilai_santri_rekap nsr JOIN santri s ON nsr.id_santri = s.id WHERE nsr.id_santri = :id_santri AND nsr.jilid = :jilid';
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id_santri' => $id_santri,
        'jilid' => $jilid
    ]);
    $dataSantri = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($dataSantri) {
        $pdf = new PDF();
        $pdf->AddPage();
        $pdf->SetFont('Arial', '', 12);

        // Konten
        $contentStartY = $pdf->GetY();

        $offsetX = 20;
        $pdf->SetX($offsetX);
        $pdf->Cell(23, 15, "No. Induk", 0, 0);
        $pdf->Cell(5, 15, ":", 0, 0);
        $pdf->Cell(83, 15, $dataSantri['id_santri'], 0, 0);
        $pdf->Cell(30, 15, "Jilid", 0, 0);
        $pdf->Cell(5, 15, ":", 0, 0);
        $pdf->Cell(60, 15, $dataSantri['jilid'], 0, 1);
        $pdf->Ln(1);

        $offsetX = 20;
        $pdf->SetX($offsetX);
        $pdf->Cell(23, 5, "Nama", 0, 0);
        $pdf->Cell(5, 5, ":", 0, 0);
        $pdf->Cell(83, 5, $dataSantri['nama'], 0, 0);
        $pdf->Cell(30, 5, "Tanggal", 0, 0);
        $pdf->Cell(5, 5, ":", 0, 0);
        $pdf->Cell(60, 5, date('d - m - Y'), 0, 1);
        $pdf->Ln(5);


        $pdf->Cell(10, 10, 'No', 1, 0, 'C');
        $pdf->Cell(140, 10, 'Mata Pelajaran', 1, 0, 'C');
        $pdf->Cell(40, 10, 'Nilai', 1, 0, 'C');
        $pdf->Ln();

        $pdf->Cell(10, 10, '1', 1, 0, 'C');
        $pdf->Cell(140, 10, 'Tajwid', 1);
        $pdf->Cell(40, 10, $dataSantri['tajwid'], 1, 0, 'C');
        $pdf->Ln();

        $pdf->Cell(10, 10, '2', 1, 0, 'C');
        $pdf->Cell(140, 10, 'Makhroj', 1);
        $pdf->Cell(40, 10, $dataSantri['makhroj'], 1, 0, 'C');
        $pdf->Ln();

        $pdf->Cell(10, 10, '3', 1, 0, 'C');
        $pdf->Cell(140, 10, 'Tartil', 1);
        $pdf->Cell(40, 10, $dataSantri['tartil'], 1, 0, 'C');
        $pdf->Ln();

        $pdf->Cell(10, 10, '4', 1, 0, 'C');
        $pdf->Cell(140, 10, 'Hafalan', 1);
        $pdf->Cell(40, 10, $dataSantri['hafalan'], 1, 0, 'C');
        $pdf->Ln();

        $pdf->Cell(10, 10, '5', 1, 0, 'C');
        $pdf->Cell(140, 10, 'Akhlaq', 1);
        $pdf->Cell(40, 10, $dataSantri['akhlaq'], 1, 0, 'C');
        $pdf->Ln();

        $pdf->Cell(150, 10, 'Total', 1, 0, 'C');
        $pdf->Cell(40, 10, $dataSantri['total'], 1, 0, 'C');
        $pdf->Ln();

        $pdf->Cell(150, 10, 'Rata - Rata', 1, 0, 'C');
        $pdf->Cell(40, 10, $dataSantri['rata_rata'], 1, 0, 'C');
        $pdf->Ln();

        $pdf->DrawContentBorder($contentStartY);

        // TTD
        $offsetX = 120;
        $pdf->SetX($offsetX);
        $pdf->Cell(19, 30, "Sidoarjo", 0, 0);
        $pdf->Cell(5, 30, ",", 0, 0);
        $pdf->Cell(5, 30, ".......................................", 0, 0);
        $pdf->Ln(20);

        $offsetX = 17;
        $pdf->SetX($offsetX);
        $pdf->Cell(75, 40, "Orang Tua / Wali", 0, 0);
        $pdf->Cell(60, 40, "Wali Kelas", 0, 0);
        $pdf->Cell(0, 40, "Kepala TPQ Al Amin", 0, 0);
        $pdf->Ln(40);

        $offsetX = 17;
        $pdf->SetX($offsetX);
        $pdf->Cell(69, 40, "______________", 0, 0);
        $pdf->Cell(69, 40, "______________", 0, 0);
        $pdf->Cell(0, 40, "______________", 0, 0);
        $pdf->Ln(1);

        $pdf->Output('I', 'rapor.pdf');
    } else {
        echo 'Data tidak ditemukan';
    }
}
