<?php
include 'assets/src/header.php';
require 'assets/src/odbc.php';

if (isset($_GET['id'])) {
    $id = $_GET['id'];
};

$sql_santri = 'SELECT * FROM santri WHERE id = :id_santri';
$stmt_santri = $pdo->prepare($sql_santri);
$stmt_santri->execute(['id_santri' => $id]);
$data_santri = $stmt_santri->fetch();
?>
<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid px-4">
            <h1 class="mt-4">Data Santri <?= $data_santri['nama']; ?></h1>
            <ol class="breadcrumb mb-4">
                <li class="breadcrumb-item active">Data Santri</li>
            </ol>
            <div class="row">
                <div class="col-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <i class="fas fa-table me-1"></i>
                            Data Santri
                        </div>
                        <div class="card-body">
                            <div class="row align-items-center mb-3">
                                <div class="col-3">
                                    <Label>NIS</Label>
                                </div>
                                <div class="col-1"> : </div>
                                <div class="col-8">
                                    <input type="text" class="form-control" value="<?= $data_santri['id']; ?>" readonly>
                                </div>
                            </div>
                            <div class="row align-items-center mb-3">
                                <div class="col-3">
                                    <Label>Nama Santri</Label>
                                </div>
                                <div class="col-1"> : </div>
                                <div class="col-8">
                                    <input type="text" class="form-control" value="<?= $data_santri['nama']; ?>" readonly>
                                </div>
                            </div>
                            <div class="row align-items-center mb-3">
                                <div class="col-3">
                                    <Label>Alamat</Label>
                                </div>
                                <div class="col-1"> : </div>
                                <div class="col-8">
                                    <textarea name="" id="" cols="41" rows="2" class="form-control" readonly><?= $data_santri['alamat']; ?></textarea>
                                </div>
                            </div>
                            <div class="row align-items-center mb-3">
                                <div class="col-3">
                                    <Label>No. Telpon</Label>
                                </div>
                                <div class="col-1"> : </div>
                                <div class="col-8">
                                    <input type="text" class="form-control" value="<?= $data_santri['telp']; ?>" readonly>
                                </div>
                            </div>
                            <div class="row align-items-center mb-3">
                                <div class="col-3">
                                    <Label>Tanggal Masuk</Label>
                                </div>
                                <div class="col-1"> : </div>
                                <div class="col-8">
                                    <?php
                                    $datetime = $data_santri['tgl_masuk'];
                                    $date = new DateTime($datetime);
                                    ?>
                                    <input type="text" class="form-control" value="<?= $date->format('d-m-Y') ?>" readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <i class="fas fa-table me-1"></i>
                            Data Rapor Santri
                        </div>
                        <div class="card-body">
                            <?php
                            $id_santri = $_GET['id'];
                            $jilid_list = [1, 2, 3, 4, 5, 6];

                            foreach ($jilid_list as $jilid) {
                                $cek = 'SELECT * FROM nilai_santri_rekap WHERE id_santri = :id_santri AND jilid = :jilid';
                                $stmt_cek = $pdo->prepare($cek);
                                $stmt_cek->execute(['id_santri' => $id_santri, 'jilid' => $jilid]);

                                if ($stmt_cek->rowCount() > 0) {
                            ?>
                                    <div class="row align-items-center mb-3">
                                        <div class="col-3">
                                            <Label>Jilid <?= $jilid; ?></Label>
                                        </div>
                                        <div class="col-1"> : </div>
                                        <div class="col-8">
                                            <form action="http://localhost/rapor/cetak.php" method="POST" target="_blank">
                                                <div class="modal-body">
                                                    <div class="">
                                                        <div class="text-center">
                                                            <input type="text" name="nis" class="form-control" value="<?= $id_santri ?>" hidden>
                                                            <input type="text" name="jilid" class="form-control" value="<?= $jilid ?>" hidden>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="footer">
                                                    <button type="submit" class="btn btn-success" name="santri_download_nilai_rekap">
                                                        <li class="fas fa-download me-2"></li>Download Rapor</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                            <?php
                                }
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <?php
    include 'assets/src/footer.php';
    ?>