<?php
include 'assets/src/header.php';
require 'assets/src/odbc.php';
?>
<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid px-4">
            <h1 class="mt-4">Data Santri </h1>
            <ol class="breadcrumb mb-4">
                <li class="breadcrumb-item active">Data Santri</li>
            </ol>
            <!-- Button trigger modal -->
            <button type="button" class="btn btn-success mb-4" data-bs-toggle="modal" data-bs-target="#tambahSantri">
                Tambahkan Santri Baru
            </button>
            <!-- Modal -->
            <div class="modal fade" id="tambahSantri" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Data Santri Baru</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form action="http://localhost/rapor/assets/src/function.php" method="POST">
                            <div class="modal-body">
                                <div class="mb-3">
                                    <div class="row g-3 align-items-center mb-2">
                                        <div class="col-4">
                                            <label for="" class="col-form-label">NIS</label>
                                        </div>
                                        <div class="col-1">
                                            <label for="" class="col-form-label">:</label>
                                        </div>
                                        <div class="col-7">
                                            <input type="number" class="form-control" name="nis">
                                        </div>
                                    </div>
                                    <div class="row g-3 align-items-center mb-2">
                                        <div class="col-4">
                                            <label for="" class="col-form-label">Nama Santri</label>
                                        </div>
                                        <div class="col-1">
                                            <label for="" class="col-form-label">:</label>
                                        </div>
                                        <div class="col-7">
                                            <input type="text" class="form-control text-uppercase" name="nama">
                                        </div>
                                    </div>
                                    <div class="row g-3 align-items-center mb-2">
                                        <div class="col-4">
                                            <label for="" class="col-form-label">Jenis Kelamin</label>
                                        </div>
                                        <div class="col-1">
                                            <label for="" class="col-form-label">:</label>
                                        </div>
                                        <div class="col-7">
                                            <select name="jk" id="" class="form-control">
                                                <option value="">-- Pilih Jenis Kelamin --</option>
                                                <option value="laki laki">LAKI-LAKI</option>
                                                <option value="perempuan">PEREMPUAN</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row g-3 align-items-center mb-2">
                                        <div class="col-4">
                                            <label for="" class="col-form-label">Alamat</label>
                                        </div>
                                        <div class="col-1">
                                            <label for="" class="col-form-label">:</label>
                                        </div>
                                        <div class="col-7">
                                            <textarea class="form-control" name="alamat" id="" cols="38" rows="5"></textarea>
                                        </div>
                                    </div>
                                    <div class="row g-3 align-items-center mb-2">
                                        <div class="col-4">
                                            <label for="" class="col-form-label">No. Telpon</label>
                                        </div>
                                        <div class="col-1">
                                            <label for="" class="col-form-label">:</label>
                                        </div>
                                        <div class="col-7">
                                            <input type="number" class="form-control text-uppercase" name="telp">
                                        </div>
                                    </div>
                                    <div class="row g-3 align-items-center mb-2">
                                        <div class="col-4">
                                            <label for="" class="col-form-label">Tanggal Masuk</label>
                                        </div>
                                        <div class="col-1">
                                            <label for="" class="col-form-label">:</label>
                                        </div>
                                        <div class="col-7">
                                            <input type="date" class="form-control text-uppercase" name="tgl_masuk">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                <button type="submit" class="btn btn-primary" name="santri_simpan">Simpan</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="card mb-4">
                <div class="card-header">
                    <div class="text-center">
                        <i class="fas fa-user-graduate me-1"></i>Data Santri
                        <hr>
                    </div>
                    <ul class="nav nav-tabs card-header-tabs" id="myTab" role="tabList">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="semua-tab" data-bs-toggle="tab" data-bs-target="#semua-tab-pane" type="button" role="tab" aria-controls="semua-tab-pane" aria-selected="true" style="width: 20vh;">Semua Santri</button>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="semua-tab-pane" role="tabpanel" aria-labelledby="semua-tab" tabindex="0">
                            <table id="datatablesSimple">
                                <thead>
                                    <tr>
                                        <th>NIS</th>
                                        <th>Nama Santri</th>
                                        <th>Jenis Kelamin</th>
                                        <th>Status</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = 'SELECT * FROM santri';
                                    $stmt = $pdo->query($sql);
                                    $i = 1;

                                    while ($data = $stmt->fetch()) :
                                    ?>
                                        <tr>
                                            <td><?= $data['id']; ?></td>
                                            <td><?= $data['nama']; ?></td>
                                            <td><?= $data['jenis_kelamin']; ?></td>
                                            <td><?= $data['status']; ?></td>
                                            <td>
                                                <a href="http://localhost/rapor/santri_detail.php?id=<?= $data['id']; ?>" type="button" class="btn btn-info btn-sm">
                                                    <li class="fas fa-gear"></li>
                                                </a>
                                                <button type="button" class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editSantri_<?= $data['id']; ?>">
                                                    <li class="fas fa-pen"></li>
                                                </button>
                                                <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#hapusSantri_<?= $data['id']; ?>">
                                                    <li class="fas fa-trash"></li>
                                                </button>
                                            </td>
                                            <!-- Modal Edit-->
                                            <div class="modal fade" id="editSantri_<?= $data['id']; ?>" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Edit Data Santri</h1>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <form action="http://localhost/rapor/assets/src/function.php" method="POST">
                                                            <div class="modal-body">
                                                                <div class="mb-3">
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">NIS</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <input type="number" class="form-control" name="nis" value="<?= $data['id']; ?>" readonly>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Nama Santri</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <input type="text" class="form-control text-uppercase" name="nama" value="<?= $data['nama'] ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-4">
                                                                            <label for="" class="col-form-label">Jenis Kelamin</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-7">
                                                                            <select name="jk" id="" class="form-control">
                                                                                <option value="<?= $data['jenis_kelamin'] ?>"><?= $data['jenis_kelamin'] ?></option>
                                                                                <option value="laki laki">LAKI-LAKI</option>
                                                                                <option value="perempuan">PEREMPUAN</option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Alamat</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <textarea name="alamat" id="" cols="38" rows="2" class="form-control"><?= $data['alamat']; ?></textarea>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Tanggal Masuk</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <?php
                                                                            $datetime = $data['tgl_masuk'];
                                                                            $date = new DateTime($datetime);
                                                                            ?>
                                                                            <input type="date" class="form-control" name="tgl_masuk" value="<?= $date->format('Y-m-d') ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">No. Telpon</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <input type="text" class="form-control text-uppercase" name="telp" value="<?= $data['telp']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Status</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <select name="status" id="" class="form-control">
                                                                                <option value="aktif" <?= $data['status'] == 'AKTIF' ? 'selected' : ''; ?>>AKTIF</option>
                                                                                <option value="non aktif" <?= $data['status'] == 'NON AKTIF' ? 'selected' : ''; ?>>NON AKTIF</option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                                <button type="submit" class="btn btn-primary" name="santri_edit">Simpan</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Modal Hapus -->
                                            <div class="modal fade" id="hapusSantri_<?= $data['id']; ?>" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Hapus Data Santri</h1>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <form action="http://localhost/rapor/assets/src/function.php" method="POST">
                                                            <div class="modal-body">
                                                                <div class="m-3">
                                                                    <div class="text-center">
                                                                        <input type="text" name="nis" class="form-control" value="<?= $data['id']; ?>" hidden>
                                                                        <label for="">Anda Yakin Ingin Menghapus Data Santri : <?= $data['nama']; ?> </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                                <button type="submit" class="btn btn-danger" name="santri_hapus">Hapus</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </tr>
                                    <?php
                                    endwhile;
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <?php
    include 'assets/src/footer.php';
    ?>