<?php
include 'assets/src/header.php';
require 'assets/src/odbc.php';
?>
<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid px-4">
            <h1 class="mt-4">Rapor Santri</h1>
            <ol class="breadcrumb mb-4">
                <li class="breadcrumb-item active">Data Rapor Santri</li>
            </ol>
            <div class="card mb-4">
                <div class="card-header">
                    <div class="text-center">
                        <i class="fas fa-user-graduate me-1"></i>Data Rapor Santri
                        <hr>
                    </div>
                    <ul class="nav nav-tabs card-header-tabs" id="myTab" role="tabList">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="semua-tab" data-bs-toggle="tab" data-bs-target="#semua-tab-pane" type="button" role="tab" aria-controls="semua-tab-pane" aria-selected="true" style="width: 20vh;">Semua Santri</button>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="semua-tab-pane" role="tabpanel" aria-labelledby="semua-tab" tabindex="0">
                            <table id="datatablesSimple">
                                <thead>
                                    <tr>
                                        <th>NIS</th>
                                        <th>Nama Santri</th>
                                        <th>Jilid</th>
                                        <th>Tartil</th>
                                        <th>Makhroj</th>
                                        <th>Tartil</th>
                                        <th>Hafalan</th>
                                        <th>Akhlaq</th>
                                        <th>Total</th>
                                        <th>Rata Rata</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if (isset($_SESSION['jilid']) && $_SESSION['jilid'] == 'ADMIN'){
                                        $sql = 'SELECT nsr.id_santri, s.nama, nsr.jilid, nsr.tajwid, nsr.makhroj, nsr.tartil, nsr.hafalan, nsr.akhlaq, nsr.total, nsr.rata_rata FROM nilai_santri_rekap nsr JOIN santri s ON nsr.id_santri = s.id AND nsr.posting = 2';
                                    } else if (isset($_SESSION['jilid'])){
                                        $jilid = $_SESSION['jilid'];

                                        $sql = "SELECT nsr.id_santri, s.nama, nsr.jilid, nsr.tajwid, nsr.makhroj, nsr.tartil, nsr.hafalan, nsr.akhlaq, nsr.total, nsr.rata_rata FROM nilai_santri_rekap nsr JOIN santri s ON nsr.id_santri = s.id AND nsr.posting = 2 AND nsr.jilid = $jilid";
                                        }
                                    $stmt = $pdo->query($sql);
                                    $i = 1;

                                    while ($data = $stmt->fetch()) :
                                    ?>
                                        <tr>
                                            <td><?= $data['id_santri']; ?></td>
                                            <td><?= $data['nama']; ?></td>
                                            <td><?= $data['jilid']; ?></td>
                                            <td><?= $data['tajwid']; ?></td>
                                            <td><?= $data['makhroj']; ?></td>
                                            <td><?= $data['tartil']; ?></td>
                                            <td><?= $data['hafalan']; ?></td>
                                            <td><?= $data['akhlaq']; ?></td>
                                            <td><?= $data['total']; ?></td>
                                            <td><?= $data['rata_rata']; ?></td>
                                            <td>
                                                <button type="button" class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#downloadNilaiSantri_<?= $data['id_santri']; ?>">
                                                    <li class="fas fa-download"></li>
                                                </button>
                                            </td>

                                            <!-- Modal Download -->
                                            <div class="modal fade" id="downloadNilaiSantri_<?= $data['id_santri']; ?>" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Download Data Nilai Santri</h1>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <form action="http://localhost/rapor/cetak.php" method="POST" target="_blank">
                                                            <div class="modal-body">
                                                                <div class="m-3">
                                                                    <div class="text-center">
                                                                        <input type="text" name="nis" class="form-control" value="<?= $data['id_santri']; ?>" hidden>
                                                                        <input type="text" name="jilid" class="form-control" value="<?= $data['jilid']; ?>" hidden>
                                                                        <label for="">Ingin Download Nilai Santri : <?= $data['nama']; ?> | Jilid : <?= $data['jilid']; ?> ? </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                                <button type="submit" class="btn btn-success" name="santri_download_nilai_rekap">Cetak</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </tr>
                                    <?php
                                    endwhile;
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <?php
    include 'assets/src/footer.php';
    ?>