<?php
include 'assets/src/header.php';
require 'assets/src/odbc.php';

$delete = "DELETE FROM nilai_santri WHERE posting = 1";
$stmt_delete = $pdo->prepare($delete);
$stmt_delete->execute();
?>
<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid px-4">
            <h1 class="mt-4">Data Nilai Santri </h1>
            <ol class="breadcrumb mb-4">
                <li class="breadcrumb-item active">Data Nilai Santri</li>
            </ol>
            <div class="card mb-4">
                <div class="card-header">
                    <div class="text-center">
                        <i class="fas fa-user-graduate me-1"></i>Data Nilai Santri
                        <hr>
                    </div>
                    <ul class="nav nav-tabs card-header-tabs" id="myTab" role="tabList">
                        <?php
                        if (isset($_SESSION['jilid'])) {
                            $session_jilid = $_SESSION['jilid'];
                        }

                        for ($jilid = 1; $jilid <= 6; $jilid++) :
                            if ($session_jilid == 0) {
                        ?>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="semua-tab" data-bs-toggle="tab" data-bs-target="#semua-tab-pane" type="button" role="tab" aria-controls="semua-tab-pane" aria-selected="true" style="width: 20vh;">Semua Santri</button>
                                </li>
                            <?php
                                break;
                            } elseif ($session_jilid == $jilid) {
                            ?>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="jilid<?= $jilid; ?>-tab" data-bs-toggle="tab" data-bs-target="#jilid<?= $jilid; ?>-tab-pane" type="button" role="tab" aria-controls="jilid<?= $jilid; ?>-tab-pane" aria-selected="false" style="width: 20vh;">Jilid <?= $jilid; ?></button>
                                </li>
                        <?php
                            };
                        endfor;
                        ?>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="semua-tab-pane" role="tabpanel" aria-labelledby="semua-tab" tabindex="0">
                            <table id="datatablesSimple">
                                <thead>
                                    <tr>
                                        <th>NIS</th>
                                        <th>Nama Santri</th>
                                        <th>Jilid</th>
                                        <th>Tajwid</th>
                                        <th>Makhroj</th>
                                        <th>Tartil</th>
                                        <th>Hafalan Surat</th>
                                        <th>Akhlaq</th>
                                        <th>Total Nilai</th>
                                        <th>Rata - Rata</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = "SELECT santri.id, santri.nama, santri.jilid, nilai_santri.tajwid, nilai_santri.makhroj, nilai_santri.tartil, nilai_santri.hafalan, nilai_santri.akhlaq, nilai_santri.total, nilai_santri.rata_rata, (COALESCE(nilai_santri.tajwid,0) + COALESCE(nilai_santri.makhroj,0) + COALESCE(nilai_santri.tartil,0) + COALESCE(nilai_santri.hafalan,0) + COALESCE(nilai_santri.akhlaq,0)) AS total_sementara, ROUND(((COALESCE(nilai_santri.tajwid,0) + COALESCE(nilai_santri.makhroj,0) + COALESCE(nilai_santri.tartil,0) + COALESCE(nilai_santri.hafalan,0) + COALESCE(nilai_santri.akhlaq,0)) / 5),2) AS rata_rata_sementara FROM santri LEFT JOIN nilai_santri ON santri.id = nilai_santri.id_santri WHERE santri.status = 'AKTIF' AND nilai_santri.posting = 0";
                                    $stmt = $pdo->query($sql);
                                    $i = 1;

                                    while ($data = $stmt->fetch()) :
                                    ?>
                                        <tr>
                                            <td><?= $data['id']; ?></td>
                                            <td><?= $data['nama']; ?></td>
                                            <td><?= $data['jilid']; ?></td>
                                            <td><?= $data['tajwid'] ?? 0; ?></td>
                                            <td><?= $data['makhroj'] ?? 0; ?></td>
                                            <td><?= $data['tartil'] ?? 0; ?></td>
                                            <td><?= $data['hafalan'] ?? 0; ?></td>
                                            <td><?= $data['akhlaq'] ?? 0; ?></td>
                                            <td><?= $data['total_sementara']; ?></td>
                                            <td><?= $data['rata_rata_sementara']; ?></td>
                                            <td>
                                                <?php
                                                $cek = 'SELECT posting FROM nilai_santri WHERE id_santri = :id_santri';
                                                $stmt_cek = $pdo->prepare($cek);
                                                $stmt_cek->execute([
                                                    'id_santri' => $data['id']
                                                ]);
                                                $result = $stmt_cek->fetch();

                                                if ($result['posting'] == 0){
                                                ?>
                                                <button type="button" class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#inputNilaiSantri_<?= $data['id']; ?>">
                                                    <li class="fas fa-pen"></li>
                                                </button>
                                                <button type="button" class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#uploadNilaiSantri_<?= $data['id']; ?>">
                                                    <li class="fas fa-upload"></li>
                                                </button>
                                                <?php
                                                };
                                                ?>
                                            </td>
                                            <!-- Modal Edit-->
                                            <div class="modal fade" id="inputNilaiSantri_<?= $data['id']; ?>" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Input Nilai Santri</h1>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <form action="http://localhost/rapor/assets/src/function.php" method="POST">
                                                            <div class="modal-body">
                                                                <div class="mb-3">
                                                                    <div class="row g-3 align-items-center">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">NIS</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <Label><?= $data['id']; ?></Label>
                                                                            <input type="number" class="form-control" name="nis" value="<?= $data['id']; ?>" hidden>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Nama Santri</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <Label><?= $data['nama']; ?></Label>
                                                                            <input type="text" class="form-control text-uppercase" name="nama" value="<?= $data['nama'] ?>" hidden>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Jilid</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <Label><?= $data['jilid']; ?></Label>
                                                                            <input type="text" class="form-control text-uppercase" name="jilid" value="<?= $data['jilid']; ?>" hidden>
                                                                        </div>
                                                                    </div>
                                                                    <hr>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Tajwid</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <input type="number" class="form-control text-uppercase" name="tajwid" value="<?= $data['tajwid']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Makhroj</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <input type="number" class="form-control text-uppercase" name="makhroj" value="<?= $data['makhroj']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Tartil</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <input type="number" class="form-control text-uppercase" name="tartil" value="<?= $data['tartil']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Hafalan Surat</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <input type="number" class="form-control text-uppercase" name="hafalan" value="<?= $data['hafalan']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Akhlaq</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <input type="number" class="form-control text-uppercase" name="akhlaq" value="<?= $data['akhlaq']; ?>">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                                <button type="submit" class="btn btn-primary" name="santri_input_nilai">Simpan</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Modal Upload -->
                                            <div class="modal fade" id="uploadNilaiSantri_<?= $data['id']; ?>" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Upload Data Nilai Santri</h1>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <form action="http://localhost/rapor/assets/src/function.php" method="POST">
                                                            <div class="modal-body">
                                                                <div class="m-3">
                                                                    <div class="text-center">
                                                                        <input type="text" name="nis" class="form-control" value="<?= $data['id']; ?>" hidden>
                                                                        <input type="text" name="jilid" class="form-control" value="<?= $data['jilid']; ?>" hidden>
                                                                        <input type="text" name="total" class="form-control" value="<?= $data['total_sementara']; ?>" hidden>
                                                                        <input type="text" name="rata_rata" class="form-control" value="<?= $data['rata_rata_sementara']; ?>" hidden>
                                                                        <label for="">Upload Data Nilai Santri : <?= $data['nama']; ?> </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                                <button type="submit" class="btn btn-success" name="santri_upload_nilai">Upload</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </tr>
                                    <?php
                                    endwhile;
                                    ?>
                                </tbody>
                            </table>
                        </div>
                        <?php
                        for ($jilid = 1; $jilid <= 6; $jilid++) :
                        ?>
                            <div class="tab-pane fade" id="jilid<?= $jilid; ?>-tab-pane" role="tabpanel" aria-labelledby="jilid<?= $jilid; ?>-tab" tabindex="0">
                                <table id="datatablesSimple<?= $jilid; ?>">
                                    <thead>
                                        <tr>
                                            <th>NIS</th>
                                            <th>Nama Santri</th>
                                            <th>Jilid</th>
                                            <th>Tajwid</th>
                                            <th>Makhroj</th>
                                            <th>Tartil</th>
                                            <th>Hafalan Surat</th>
                                            <th>Akhlaq</th>
                                            <th>Total Nilai</th>
                                            <th>Rata - Rata</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $i = 1;
                                        $sql = "SELECT santri.id, santri.nama, santri.jilid, nilai_santri.tajwid, nilai_santri.makhroj, nilai_santri.tartil, nilai_santri.hafalan, nilai_santri.akhlaq, nilai_santri.total, nilai_santri.rata_rata, (COALESCE(nilai_santri.tajwid,0) + COALESCE(nilai_santri.makhroj,0) + COALESCE(nilai_santri.tartil,0) + COALESCE(nilai_santri.hafalan,0) + COALESCE(nilai_santri.akhlaq,0)) AS total_sementara, ROUND(((COALESCE(nilai_santri.tajwid,0) + COALESCE(nilai_santri.makhroj,0) + COALESCE(nilai_santri.tartil,0) + COALESCE(nilai_santri.hafalan,0) + COALESCE(nilai_santri.akhlaq,0)) / 5),2) AS rata_rata_sementara FROM santri LEFT JOIN nilai_santri ON santri.id = nilai_santri.id_santri WHERE santri.jilid = $jilid";
                                        $stmt = $pdo->query($sql);
                                        $i = 1;

                                        while ($data = $stmt->fetch()) :
                                        ?>
                                            <tr>
                                                <td><?= $data['id']; ?></td>
                                                <td><?= $data['nama']; ?></td>
                                                <td><?= $data['jilid']; ?></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td>
                                                    <button type="button" class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#inputNilaiSantriJilid_<?= $data['id']; ?>">
                                                        <li class="fas fa-pen"></li>
                                                    </button>
                                                    <button type="button" class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#uploadNilaiSantriJilid_<?= $data['id']; ?>">
                                                        <li class="fas fa-upload"></li>
                                                    </button>
                                                </td>
                                                <!-- Modal Edit-->
                                                <div class="modal fade" id="inputNilaiSantriJilid_<?= $data['id']; ?>" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                    <div class="modal-dialog modal-dialog-centered">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h1 class="modal-title fs-5" id="staticBackdropLabel">Input Nilai Santri</h1>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <form action="http://localhost/rapor/assets/src/function.php" method="POST">
                                                                <div class="modal-body">
                                                                    <div class="mb-3">
                                                                        <div class="row g-3 align-items-center">
                                                                            <div class="col-3">
                                                                                <label for="" class="col-form-label">NIS</label>
                                                                            </div>
                                                                            <div class="col-1">
                                                                                <label for="" class="col-form-label">:</label>
                                                                            </div>
                                                                            <div class="col-8">
                                                                                <Label><?= $data['id']; ?></Label>
                                                                                <input type="number" class="form-control" name="nis" value="<?= $data['id']; ?>" hidden>
                                                                            </div>
                                                                        </div>
                                                                        <div class="row g-3 align-items-center">
                                                                            <div class="col-3">
                                                                                <label for="" class="col-form-label">Nama Santri</label>
                                                                            </div>
                                                                            <div class="col-1">
                                                                                <label for="" class="col-form-label">:</label>
                                                                            </div>
                                                                            <div class="col-8">
                                                                                <Label><?= $data['nama']; ?></Label>
                                                                                <input type="text" class="form-control text-uppercase" name="nama" value="<?= $data['nama'] ?>" hidden>
                                                                            </div>
                                                                        </div>
                                                                        <div class="row g-3 align-items-center">
                                                                            <div class="col-3">
                                                                                <label for="" class="col-form-label">Jilid</label>
                                                                            </div>
                                                                            <div class="col-1">
                                                                                <label for="" class="col-form-label">:</label>
                                                                            </div>
                                                                            <div class="col-8">
                                                                                <Label><?= $data['jilid']; ?></Label>
                                                                                <input type="text" class="form-control text-uppercase" name="jilid" value="<?= $data['jilid']; ?>" hidden>
                                                                            </div>
                                                                        </div>
                                                                        <hr>
                                                                        <div class="row g-3 align-items-center mb-2">
                                                                            <div class="col-3">
                                                                                <label for="" class="col-form-label">Tajwid</label>
                                                                            </div>
                                                                            <div class="col-1">
                                                                                <label for="" class="col-form-label">:</label>
                                                                            </div>
                                                                            <div class="col-8">
                                                                                <input type="number" class="form-control text-uppercase" name="tajwid">
                                                                            </div>
                                                                        </div>
                                                                        <div class="row g-3 align-items-center mb-2">
                                                                            <div class="col-3">
                                                                                <label for="" class="col-form-label">Makhroj</label>
                                                                            </div>
                                                                            <div class="col-1">
                                                                                <label for="" class="col-form-label">:</label>
                                                                            </div>
                                                                            <div class="col-8">
                                                                                <input type="number" class="form-control text-uppercase" name="makhroj">
                                                                            </div>
                                                                        </div>
                                                                        <div class="row g-3 align-items-center mb-2">
                                                                            <div class="col-3">
                                                                                <label for="" class="col-form-label">Tartil</label>
                                                                            </div>
                                                                            <div class="col-1">
                                                                                <label for="" class="col-form-label">:</label>
                                                                            </div>
                                                                            <div class="col-8">
                                                                                <input type="number" class="form-control text-uppercase" name="tartil">
                                                                            </div>
                                                                        </div>
                                                                        <div class="row g-3 align-items-center mb-2">
                                                                            <div class="col-3">
                                                                                <label for="" class="col-form-label">Hafalan Surat</label>
                                                                            </div>
                                                                            <div class="col-1">
                                                                                <label for="" class="col-form-label">:</label>
                                                                            </div>
                                                                            <div class="col-8">
                                                                                <input type="number" class="form-control text-uppercase" name="hafalan">
                                                                            </div>
                                                                        </div>
                                                                        <div class="row g-3 align-items-center mb-2">
                                                                            <div class="col-3">
                                                                                <label for="" class="col-form-label">Akhlaq</label>
                                                                            </div>
                                                                            <div class="col-1">
                                                                                <label for="" class="col-form-label">:</label>
                                                                            </div>
                                                                            <div class="col-8">
                                                                                <input type="number" class="form-control text-uppercase" name="akhlaq">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                                    <button type="submit" class="btn btn-primary" name="santri_input_nilai">Simpan</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Modal Upload -->
                                                <div class="modal fade" id="uploadNilaiSantriJilid_<?= $data['id']; ?>" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                    <div class="modal-dialog modal-dialog-centered">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h1 class="modal-title fs-5" id="staticBackdropLabel">Upload Data Nilai Santri</h1>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <form action="http://localhost/rapor/assets/src/function.php" method="POST">
                                                                <div class="modal-body">
                                                                    <div class="m-3">
                                                                        <div class="text-center">
                                                                            <input type="text" name="nis" class="form-control" value="<?= $data['id']; ?>">
                                                                            <input type="text" name="jilid" class="form-control" value="<?= $data['jilid']; ?>">
                                                                            <label for="">Upload Data Nilai Santri : <?= $data['nama'], $data['jilid'];; ?> </label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                                    <button type="submit" class="btn btn-success" name="santri_upload_nilai">Upload</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </tr>
                                        <?php
                                        endwhile;
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php
                        endfor;
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <?php
    include 'assets/src/footer.php';
    ?>