<?php
include 'assets/src/header.php';
require 'assets/src/odbc.php';
?>
<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid px-4">
            <h1 class="mt-4">Data Nilai Santri Rekap</h1>
            <ol class="breadcrumb mb-4">
                <li class="breadcrumb-item active">Data Nilai Santri Rekap</li>
            </ol>
            <div class="card mb-4">
                <div class="card-header">
                    <div class="text-center">
                        <i class="fas fa-user-graduate me-1"></i>Data Nilai Santri Rekap
                        <hr>
                    </div>
                    <ul class="nav nav-tabs card-header-tabs" id="myTab" role="tabList">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="semua-tab" data-bs-toggle="tab" data-bs-target="#semua-tab-pane" type="button" role="tab" aria-controls="semua-tab-pane" aria-selected="true" style="width: 20vh;">Semua Santri</button>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="semua-tab-pane" role="tabpanel" aria-labelledby="semua-tab" tabindex="0">
                            <table id="datatablesSimple">
                                <thead>
                                    <tr>
                                        <th>NIS</th>
                                        <th>Nama Santri</th>
                                        <th>Jilid</th>
                                        <th>Tartil</th>
                                        <th>Makhroj</th>
                                        <th>Tartil</th>
                                        <th>Hafalan</th>
                                        <th>Akhlaq</th>
                                        <th>Total</th>
                                        <th>Rata Rata</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = 'SELECT nsr.id_santri, s.nama, nsr.jilid, nsr.tajwid, nsr.makhroj, nsr.tartil, nsr.hafalan, nsr.akhlaq, nsr.total, nsr.rata_rata FROM nilai_santri_rekap nsr JOIN santri s ON nsr.id_santri = s.id AND nsr.posting = 1';
                                    $stmt = $pdo->query($sql);
                                    $i = 1;

                                    while ($data = $stmt->fetch()) :
                                    ?>
                                        <tr>
                                            <td><?= $data['id_santri']; ?></td>
                                            <td><?= $data['nama']; ?></td>
                                            <td><?= $data['jilid']; ?></td>
                                            <td><?= $data['tajwid']; ?></td>
                                            <td><?= $data['makhroj']; ?></td>
                                            <td><?= $data['tartil']; ?></td>
                                            <td><?= $data['hafalan']; ?></td>
                                            <td><?= $data['akhlaq']; ?></td>
                                            <td><?= $data['total']; ?></td>
                                            <td><?= $data['rata_rata']; ?></td>
                                            <td>
                                                <button type="button" class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#inputNilaiSantri_<?= $data['id_santri']; ?>">
                                                    <li class="fas fa-pen"></li>
                                                </button>
                                                </button>
                                                <button type="button" class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#uploadNilaiSantri_<?= $data['id_santri'];?>">
                                                    <li class="fas fa-upload"></li>
                                                </button>
                                            </td>

                                            <!-- Modal Input Nilai -->
                                            <div class="modal fade" id="inputNilaiSantri_<?= $data['id_santri']; ?>" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Input Nilai Santri</h1>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <form action="http://localhost/rapor/assets/src/function.php" method="POST">
                                                            <div class="modal-body">
                                                                <div class="mb-3">
                                                                    <div class="row g-3 align-items-center">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">NIS</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <Label><?= $data['id_santri']; ?></Label>
                                                                            <input type="number" class="form-control" name="nis" value="<?= $data['id_santri']; ?>" hidden>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Nama Santri</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <Label><?= $data['nama']; ?></Label>
                                                                            <input type="text" class="form-control text-uppercase" name="nama" value="<?= $data['nama'] ?>" hidden>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Jilid</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <Label><?= $data['jilid']; ?></Label>
                                                                            <input type="text" class="form-control text-uppercase" name="jilid" value="<?= $data['jilid']; ?>" hidden>
                                                                        </div>
                                                                    </div>
                                                                    <hr>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Tajwid</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <input type="number" class="form-control text-uppercase" name="tajwid" value="<?= $data['tajwid']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Makhroj</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <input type="number" class="form-control text-uppercase" name="makhroj" value="<?= $data['makhroj']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Tartil</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <input type="number" class="form-control text-uppercase" name="tartil" value="<?= $data['tartil']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Hafalan Surat</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <input type="number" class="form-control text-uppercase" name="hafalan" value="<?= $data['hafalan']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="row g-3 align-items-center mb-2">
                                                                        <div class="col-3">
                                                                            <label for="" class="col-form-label">Akhlaq</label>
                                                                        </div>
                                                                        <div class="col-1">
                                                                            <label for="" class="col-form-label">:</label>
                                                                        </div>
                                                                        <div class="col-8">
                                                                            <input type="number" class="form-control text-uppercase" name="akhlaq" value="<?= $data['akhlaq']; ?>">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                                <button type="submit" class="btn btn-primary" name="santri_edit_nilai_rekap">Simpan</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Modal Upload -->
                                            <div class="modal fade" id="uploadNilaiSantri_<?= $data['id_santri']; ?>" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Upload Data Nilai Santri</h1>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <form action="http://localhost/rapor/assets/src/function.php" method="POST">
                                                            <div class="modal-body">
                                                                <div class="m-3">
                                                                    <div class="text-center">
                                                                        <input type="text" name="nis" class="form-control" value="<?= $data['id_santri']; ?>" hidden>
                                                                        <input type="text" name="jilid" class="form-control" value="<?= $data['jilid']; ?>" hidden>
                                                                        <label for="">Upload Data Nilai Santri : <?= $data['nama']; ?> </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                                <button type="submit" class="btn btn-success" name="santri_upload_nilai_rekap">Upload</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </tr>
                                    <?php
                                    endwhile;
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <?php
    include 'assets/src/footer.php';
    ?>