<?php

require 'odbc.php';


// ============ Verifikasi Login ============
if (isset($_POST['login'])) {
    if (isset($_POST['login'])) {
        session_start();

        $username = $_POST['username'];
        $password = $_POST['password'];

        // Verifikasi pengguna
        $stmt = $pdo->prepare('SELECT * FROM user WHERE username = :username && password = :password');
        $stmt->execute(['username' => $username, 'password' => $password]);
        $user = $stmt->fetch();

        if ($user) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['nama'] = $user['nama'];
            $_SESSION['jilid'] = $user['jilid'];
            $_SESSION['level'] = $user['level'];
            if ($_SESSION['level'] == 1 || $_SESSION['level'] == 2) {
                header('location: http://localhost/rapor/index.php');
                exit();
            } else {
                session_unset();
                session_destroy();
                header('location: http://localhost/rapor.login.php');
                exit();
            }
        } else if (!$user && $username == 'superadmin' && $password == '123') {
            $_SESSION['user_id'] = '14';
            $_SESSION['nama'] = 'super admin';
            $_SESSION['jilid'] = '0';
            $_SESSION['level'] = '0';
            header('location:http://localhost/rapor/index.php');
            exit();
        } else {
            header('location:http://localhost/rapor/login.php');
            exit();
        }
    }
}
// ============ End Verifikasi Login ============

// ============ Akun Guru & Admin ============
if (isset($_POST['guru_simpan']) || isset($_POST['admin_simpan'])) {
    $nip = $_POST['nip'];
    $nama = strtoupper($_POST['nama']);
    $jilid = strtoupper($_POST['jilid']);
    $username = $_POST['username'];
    $password = $_POST['password'];
    if (isset($_POST['guru_simpan'])) {
        $level = '2';
    } else {
        $level = '1';
    }

    $sql = 'INSERT INTO user (id, nama, jilid, username, password, level) VALUES (:nip, :nama, :jilid, :username, :password, :level)';
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['nip' => $nip, 'nama' => $nama, 'jilid' => $jilid, 'username' => $username, 'password' => $password, 'level' => $level]);

    if (isset($_POST['guru_simpan'])) {
        header('location: http://localhost/rapor/setting_guru.php');
        exit();
    } else {
        header('location: http://localhost/rapor/setting_admin.php');
        exit();
    }
} else if (isset($_POST['guru_edit']) || isset($_POST['admin_edit'])) {
    $nip = $_POST['nip'];
    $nama = strtoupper($_POST['nama']);
    $jilid = strtoupper($_POST['jilid']);
    $username = $_POST['username'];
    $password = $_POST['password'];

    $sql = 'UPDATE user SET nama = :nama, jilid = :jilid, username = :username, password = :password WHERE id = :nip';
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['nip' => $nip, 'nama' => $nama, 'jilid' => $jilid, 'username' => $username, 'password' => $password]);

    if (isset($_POST['guru_edit'])) {
        header('location: http://localhost/rapor/setting_guru.php');
        exit();
    } else {
        header('location: http://localhost/rapor/setting_admin.php');
        exit();
    }
} else if (isset($_POST['guru_hapus']) || isset($_POST['admin_hapus'])) {
    $nip = $_POST['nip'];

    $sql = 'DELETE FROM user WHERE id = :nip';
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['nip' => $nip]);

    if (isset($_POST['guru_hapus'])) {
        header('location: http://localhost/rapor/setting_guru.php');
        exit();
    } else {
        header('location: http://localhost/rapor/setting_admin.php');
        exit();
    }
}
// ============ End Akun Guru ============

// ============ Santri ============
if (isset($_POST['santri_simpan'])) {
    $nis = $_POST['nis'];
    $nama = strtoupper($_POST['nama']);
    $jk = strtoupper($_POST['jk']);
    $alamat = $_POST['alamat'];
    $telp = $_POST['telp'];
    $tgl_masuk = $_POST['tgl_masuk'];

    $sql = 'INSERT INTO santri (id, nama, jenis_kelamin, alamat, telp, tgl_masuk, status) VALUES (:nis, :nama, :jk, :alamat, :telp, :tgl_masuk, :status)';
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['nis' => $nis, 'nama' => $nama, 'jk' => $jk, 'alamat' => $alamat, 'telp' => $telp, 'tgl_masuk' => $tgl_masuk, 'status' => 'AKTIF']);

    header('location: http://localhost/rapor/santri.php');
    exit();
} else if (isset($_POST['santri_edit'])) {
    $nis = $_POST['nis'];
    $nama = strtoupper($_POST['nama']);
    $jk = strtoupper($_POST['jk']);
    $alamat = $_POST['alamat'];
    $telp = $_POST['telp'];
    $tgl_masuk = $_POST['tgl_masuk'];
    $status = strtoupper($_POST['status']);

    $sql = 'UPDATE santri SET nama = :nama, jenis_kelamin = :jk, alamat = :alamat, telp = :telp, status = :status WHERE id = :nis';
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['nis' => $nis, 'nama' => $nama, 'jk' => $jk, 'alamat' => $alamat, 'telp' => $telp, 'status' => $status]);

    header('location: http://localhost/rapor/santri.php');
    exit();
} else if (isset($_POST['santri_hapus'])) {
    $nis = $_POST['nis'];

    $sql = 'DELETE FROM santri WHERE id = :nis';
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['nis' => $nis]);

    header('location: http://localhost/rapor/santri.php');
    exit();
}
// ============ End Santri ============

// ============ Start Santri Jilid ============

if (isset($_POST['santri_jilid_simpan'])) {
    $nis = $_POST['nis'];
    $jilid = $_POST['jilid'];

    $sql = 'INSERT INTO nilai_santri (id_santri, jilid) VALUES (:id_santri, :jilid)';
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id_santri' => $nis,
        'jilid' => $jilid
    ]);

    header("location: http://localhost/rapor/jilid.php");
    exit();
} else if (isset($_POST['santri_jilid_edit'])) {
    $nis = $_POST['nis'];
    $jilid = $_POST['jilid'];

    $sql = 'UPDATE nilai_santri SET jilid = :jilid WHERE id_santri = :id_santri';
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id_santri' => $nis,
        'jilid' => $jilid
    ]);

    header("location: http://localhost/rapor/jilid.php");
    exit();
} else if (isset($_POST['santri_hapus_nilai'])) {
    $nis = $_POST['nis'];
    $jilid = $_POST['jilid'];

    $sql = 'DELETE FROM nilai_santri WHERE id_santri = :id_santri AND jilid = :jilid';
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id_santri' => $nis,
        'jilid' => $jilid
    ]);
    header("location: http://localhost/rapor/jilid.php");
}

// ============ End Santri Jilid ============

// ============ Nilai Santri ============
if (isset($_POST['santri_input_nilai'])) {
    $nis = $_POST['nis'];
    $jilid = $_POST['jilid'];
    $tajwid = $_POST['tajwid'];
    $makhroj = $_POST['makhroj'];
    $tartil = $_POST['tartil'];
    $hafalan = $_POST['hafalan'];
    $akhlaq = $_POST['akhlaq'];

    $sql = 'UPDATE nilai_santri SET tajwid = :tajwid, makhroj = :makhroj, tartil = :tartil, hafalan = :hafalan, akhlaq = :akhlaq WHERE id_santri = :id_santri AND jilid = :jilid';
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id_santri' => $nis,
        'jilid' => $jilid,
        'tajwid' => $tajwid,
        'makhroj' => $makhroj,
        'tartil' => $tartil,
        'hafalan' => $hafalan,
        'akhlaq' => $akhlaq
    ]);    

    header("location: http://localhost/rapor/nilai_santri.php");
    exit();

} else if (isset($_POST['santri_upload_nilai'])) {
    $nis = $_POST['nis'];
    $jilid = $_POST['jilid'];
    $total = $_POST['total'];
    $rata_rata = $_POST['rata_rata'];

    $sql = 'UPDATE nilai_santri SET total = :total, rata_rata = :rata_rata, posting = :posting WHERE id_santri = :id_santri AND jilid = :jilid';
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id_santri' => $nis,
        'jilid' => $jilid,
        'total' => $total,
        'rata_rata' => $rata_rata,
        'posting' => 1
    ]);
    header("location: http://localhost/rapor/nilai_santri.php");
    exit();

}

// ============ End Nilai Santri ============

// ============ Start Santri Jilid ============

if (isset($_POST['santri_jilid_simpan'])) {
    $nis = $_POST['nis'];
    $jilid = $_POST['jilid'];

    $sql = 'INSERT INTO nilai_santri (id_santri, jilid) VALUES (:id_santri, :jilid)';
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id_santri' => $nis,
        'jilid' => $jilid
    ]);

    header("location: http://localhost/rapor/jilid.php");
    exit();
} else if (isset($_POST['santri_jilid_edit'])) {
    $nis = $_POST['nis'];
    $jilid = $_POST['jilid'];

    $sql = 'UPDATE nilai_santri SET jilid = :jilid WHERE id_santri = :id_santri';
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id_santri' => $nis,
        'jilid' => $jilid
    ]);

    header("location: http://localhost/rapor/jilid.php");
    exit();
} else if (isset($_POST['santri_hapus_nilai'])) {
    $nis = $_POST['nis'];
    $jilid = $_POST['jilid'];

    $sql = 'DELETE FROM nilai_santri WHERE id_santri = :id_santri AND jilid = :jilid';
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id_santri' => $nis,
        'jilid' => $jilid
    ]);
    header("location: http://localhost/rapor/jilid.php");
}

// ============ End Santri Jilid ============

// ============ Nilai Santri Rekap ============
if (isset($_POST['santri_edit_nilai_rekap'])) {
    $nis = $_POST['nis'];
    $jilid = $_POST['jilid'];
    $tajwid = $_POST['tajwid'];
    $makhroj = $_POST['makhroj'];
    $tartil = $_POST['tartil'];
    $hafalan = $_POST['hafalan'];
    $akhlaq = $_POST['akhlaq'];

    $sql = 'UPDATE nilai_santri_rekap SET tajwid = :tajwid, makhroj = :makhroj, tartil = :tartil, hafalan = :hafalan, akhlaq = :akhlaq, total = :total, rata_rata = :rata_rata WHERE id_santri = :id_santri AND jilid = :jilid';
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id_santri' => $nis,
        'jilid' => $jilid,
        'tajwid' => $tajwid,
        'makhroj' => $makhroj,
        'tartil' => $tartil,
        'hafalan' => $hafalan,
        'akhlaq' => $akhlaq,
        'total' => ($tajwid+$makhroj+$tartil+$hafalan+$akhlaq),
        'rata_rata' => ($tajwid+$makhroj+$tartil+$hafalan+$akhlaq)/5
    ]);    

    header("location: http://localhost/rapor/nilai_santri_rekap.php");
    exit();

} else if (isset($_POST['santri_upload_nilai_rekap'])) {
    $nis = $_POST['nis'];
    $jilid = $_POST['jilid'];

    $sql = 'UPDATE nilai_santri_rekap SET posting = :posting WHERE id_santri = :id_santri AND jilid = :jilid';
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id_santri' => $nis,
        'jilid' => $jilid,
        'posting' => 2
    ]);
    header("location: http://localhost/rapor/nilai_santri_rekap.php");
    exit();

}

// ============ End Nilai Santri Rekap ============