/*
 * Decompiled with CFR 0.152.
 */
package pakaian;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import koneksi.Koneksi;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import pakaian.menu;

public class jualan
extends JFrame {
    private final Connection conn = new Koneksi().connect();
    private DefaultTableModel modelBelanja;
    private int nomorUrut = 1;
    private boolean isFullScreen = false;
    private GraphicsDevice gd;
    private JButton bayarbelanja;
    private JButton carikodebarang;
    private JButton carinohppelanggan;
    private JTextField harga;
    private JButton hitungbelanja;
    private JButton jButton4;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField jmlhbrg;
    private JTextField kembali;
    private JTextField kodebarang;
    private JTextField namabarang;
    private JTextField namapelanggan;
    private JTextField nohp_pelanggan;
    private JTable tabelbelanja;
    private JTable tabelpenjualan;
    private JTextField tgl;
    private JTextField totalbelanja;
    private JButton totalsemuabelanja;
    private JTextField txtCari;
    private JTextField uang;

    public jualan() {
        this.initComponents();
        this.tengah();
        this.tabelPenjualan();
        this.setTanggal();
        this.setupCariField();
        this.modelBelanja = new DefaultTableModel();
        this.modelBelanja.addColumn("No");
        this.modelBelanja.addColumn("Kode Barang");
        this.modelBelanja.addColumn("Nama Barang");
        this.modelBelanja.addColumn("Jumlah Barang");
        this.modelBelanja.addColumn("Harga Barang");
        this.tabelbelanja.setModel(this.modelBelanja);
    }

    private void setupCariField() {
        this.txtCari.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                jualan.this.filterPenjualan(jualan.this.txtCari.getText());
            }
        });
    }

    private void filterPenjualan(String query) {
        DefaultTableModel model = (DefaultTableModel)this.tabelpenjualan.getModel();
        model.setRowCount(0);
        try {
            String sql = "SELECT * FROM penjualan WHERE nohp_pel LIKE ? OR tanggal LIKE ?";
            PreparedStatement pst = this.conn.prepareStatement(sql);
            pst.setString(1, "%" + query + "%");
            pst.setString(2, "%" + query + "%");
            ResultSet res = pst.executeQuery();
            while (res.next()) {
                model.addRow(new Object[]{res.getDate("tanggal"), res.getString("nohp_pel"), res.getString("nama"), res.getString("kd_brg"), res.getString("nama_brg"), res.getDouble("hrg"), res.getInt("qty"), res.getDouble("total"), res.getDouble("bayar"), res.getDouble("kembali")});
            }
            this.tabelpenjualan.setModel(model);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage());
        }
    }

    public void tengah() {
        Dimension dimmax = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimframe = this.getSize();
        this.setLocation((dimmax.width - dimframe.width) / 2, (dimmax.height - dimframe.height) / 2);
    }

    protected void aktif() {
        this.nohp_pelanggan.setEnabled(true);
        this.kodebarang.setEnabled(true);
        this.jmlhbrg.setEnabled(true);
        this.uang.setEnabled(true);
        this.tgl.setEnabled(false);
        this.namapelanggan.setEnabled(false);
        this.namabarang.setEnabled(false);
        this.harga.setEnabled(false);
        this.totalbelanja.setEnabled(false);
        this.kembali.setEnabled(false);
    }

    protected void kosong() {
        this.nohp_pelanggan.setText("");
        this.namapelanggan.setText("");
        this.kodebarang.setText("");
        this.namabarang.setText("");
        this.harga.setText("");
        this.jmlhbrg.setText("");
        this.totalbelanja.setText("");
        this.uang.setText("");
        this.kembali.setText("");
        this.setTanggal();
    }

    private void setTanggal() {
        SimpleDateFormat formatTanggal = new SimpleDateFormat("yyyy-MM-dd");
        Date tanggalSekarang = new Date();
        this.tgl.setText(formatTanggal.format(tanggalSekarang));
        this.tgl.setEnabled(false);
    }

    public void tabelPenjualan() {
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn("Tanggal");
        model.addColumn("No HP Pelanggan");
        model.addColumn("Nama Pelanggan");
        model.addColumn("Kode Barang");
        model.addColumn("Nama Barang");
        model.addColumn("Harga");
        model.addColumn("Jumlah Barang");
        model.addColumn("Total Belanja");
        model.addColumn("Uang");
        model.addColumn("Kembali");
        try {
            String sql = "SELECT * FROM penjualan";
            Statement stm = this.conn.createStatement();
            ResultSet res = stm.executeQuery(sql);
            while (res.next()) {
                model.addRow(new Object[]{res.getDate("tanggal"), res.getString("nohp_pel"), res.getString("nama"), res.getString("kd_brg"), res.getString("nama_brg"), res.getDouble("hrg"), res.getInt("qty"), res.getDouble("total"), res.getDouble("bayar"), res.getDouble("kembali")});
            }
            this.tabelpenjualan.setModel(model);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage());
        }
    }

    private void hitungBelanja() {
        if (this.jmlhbrg.getText().trim().isEmpty() || this.harga.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(null, "Lengkapi data sebelum menghitung total belanja.");
            return;
        }
        try {
            double hargaBarang = Double.parseDouble(this.harga.getText().replace(",", "."));
            int jumlahBarang = Integer.parseInt(this.jmlhbrg.getText());
            double totalBelanja = hargaBarang * (double)jumlahBarang;
            this.totalbelanja.setText(String.format("%.2f", totalBelanja));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Format angka tidak valid: " + e.getMessage());
        }
    }

    private void masukkanKeTabel() {
        if (this.kodebarang.getText().trim().isEmpty() || this.namabarang.getText().trim().isEmpty() || this.harga.getText().trim().isEmpty() || this.jmlhbrg.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(null, "Lengkapi data sebelum memasukkan ke tabel belanja.");
            return;
        }
        try {
            double hargaBarang = Double.parseDouble(this.harga.getText().replace(",", "."));
            int jumlahBarang = Integer.parseInt(this.jmlhbrg.getText());
            this.modelBelanja.addRow(new Object[]{this.nomorUrut++, this.kodebarang.getText(), this.namabarang.getText(), jumlahBarang, hargaBarang});
            this.kodebarang.setText("");
            this.namabarang.setText("");
            this.harga.setText("");
            this.jmlhbrg.setText("");
            this.totalbelanja.setText("");
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Format angka tidak valid: " + e.getMessage());
        }
    }

    private void totalSemuaBelanja() {
        double totalSemua = 0.0;
        for (int i = 0; i < this.modelBelanja.getRowCount(); ++i) {
            totalSemua += (Double)this.modelBelanja.getValueAt(i, 4) * (double)((Integer)this.modelBelanja.getValueAt(i, 3)).intValue();
        }
        this.totalbelanja.setText(String.format("%.2f", totalSemua));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bayarBelanja() {
        DefaultTableModel model = (DefaultTableModel)this.tabelbelanja.getModel();
        if (model.getRowCount() == 0) {
            JOptionPane.showMessageDialog(null, "Anda tidak belanja apapun.");
            return;
        }
        try {
            double uangBayar;
            double totalBelanja;
            String totalBelanjaText = this.totalbelanja.getText().replace(",", ".");
            String uangBayarText = this.uang.getText().replace(",", ".");
            if (totalBelanjaText.isEmpty() || uangBayarText.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Total belanja atau uang bayar tidak boleh kosong.");
                return;
            }
            try {
                totalBelanja = Double.parseDouble(totalBelanjaText);
                uangBayar = Double.parseDouble(uangBayarText);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "Format angka tidak valid: " + e.getMessage());
                return;
            }
            if (uangBayar < totalBelanja) {
                JOptionPane.showMessageDialog(null, "Uang kurang, silahkan cukupi uang terlebih dahulu.");
                return;
            }
            double kembalian = uangBayar - totalBelanja;
            this.kembali.setText(String.format("%.2f", kembalian));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String tanggalTransaksi = sdf.format(new Date());
            String sqlInsert = "INSERT INTO penjualan (tanggal, nohp_pel, nama, kd_brg, nama_brg, hrg, qty, total, bayar, kembali) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement stat = this.conn.prepareStatement(sqlInsert);
            String sqlUpdateStok = "UPDATE barang SET stok = stok - ?, tgl = ? WHERE kd_brg = ?";
            String sqlCheckStok = "SELECT stok FROM barang WHERE kd_brg = ?";
            this.conn.setAutoCommit(false);
            try {
                for (int i = 0; i < model.getRowCount(); ++i) {
                    int stokTersedia;
                    double hargaBarang;
                    int jumlahBarang;
                    String kodeBarang = model.getValueAt(i, 1).toString();
                    String namaBarang = model.getValueAt(i, 2).toString();
                    String jumlahBarangText = model.getValueAt(i, 3).toString();
                    String hargaBarangText = model.getValueAt(i, 4).toString();
                    if (jumlahBarangText.isEmpty() || hargaBarangText.isEmpty()) {
                        JOptionPane.showMessageDialog(null, "Jumlah atau harga barang tidak boleh kosong.");
                        this.conn.rollback();
                        return;
                    }
                    try {
                        jumlahBarang = Integer.parseInt(jumlahBarangText);
                        hargaBarang = Double.parseDouble(hargaBarangText);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(null, "Format angka tidak valid: " + e.getMessage());
                        this.conn.rollback();
                        this.conn.setAutoCommit(true);
                        return;
                    }
                    PreparedStatement checkStok = this.conn.prepareStatement(sqlCheckStok);
                    checkStok.setString(1, kodeBarang);
                    ResultSet rs = checkStok.executeQuery();
                    if (rs.next() && (stokTersedia = rs.getInt("stok")) < jumlahBarang) {
                        JOptionPane.showMessageDialog(null, "Stok untuk barang " + namaBarang + " kurang. Stok tersedia: " + stokTersedia);
                        this.conn.rollback();
                        return;
                    }
                    stat.setString(1, this.tgl.getText());
                    stat.setString(2, this.nohp_pelanggan.getText());
                    stat.setString(3, this.namapelanggan.getText());
                    stat.setString(4, kodeBarang);
                    stat.setString(5, namaBarang);
                    stat.setDouble(6, hargaBarang);
                    stat.setInt(7, jumlahBarang);
                    stat.setDouble(8, totalBelanja);
                    stat.setDouble(9, uangBayar);
                    stat.setDouble(10, kembalian);
                    stat.addBatch();
                    PreparedStatement updateStok = this.conn.prepareStatement(sqlUpdateStok);
                    updateStok.setInt(1, jumlahBarang);
                    updateStok.setString(2, tanggalTransaksi);
                    updateStok.setString(3, kodeBarang);
                    updateStok.executeUpdate();
                }
                stat.executeBatch();
                this.conn.commit();
                JOptionPane.showMessageDialog(null, "PEMBAYARAN BERHASIL!!!");
                model.setRowCount(0);
                int printOption = JOptionPane.showConfirmDialog(null, "Apakah Anda ingin mencetak nota?", "Cetak Nota", 0);
                if (printOption == 0) {
                    String nota = this.formatNota();
                    this.printNota(nota);
                }
            }
            catch (SQLException e) {
                this.conn.rollback();
                JOptionPane.showMessageDialog(null, "Gagal menyimpan data: " + e.getMessage());
            }
            finally {
                this.conn.setAutoCommit(true);
            }
            this.kosong();
            this.tabelPenjualan();
            this.aktif();
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Format angka tidak valid: " + e.getMessage());
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Gagal menyimpan data: " + e.getMessage());
        }
    }

    private String formatNota() {
        StringBuilder nota = new StringBuilder();
        nota.append("Toko Baju\n");
        nota.append("------------------------------\n");
        nota.append("Tanggal: ").append(new SimpleDateFormat("yyyy-MM-dd").format(new Date())).append("\n");
        nota.append("No HP: ").append(this.nohp_pelanggan.getText()).append("\n");
        nota.append("Nama: ").append(this.namapelanggan.getText()).append("\n");
        nota.append("------------------------------\n");
        DefaultTableModel model = (DefaultTableModel)this.tabelbelanja.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            String kodeBarang = model.getValueAt(i, 1).toString();
            String namaBarang = model.getValueAt(i, 2).toString();
            String jumlahBarang = model.getValueAt(i, 3).toString();
            String hargaBarang = model.getValueAt(i, 4).toString();
            nota.append(String.format("%s %s x%s @%s\n", kodeBarang, namaBarang, jumlahBarang, hargaBarang));
        }
        nota.append("------------------------------\n");
        nota.append("Total: ").append(this.totalbelanja.getText()).append("\n");
        nota.append("Bayar: ").append(this.uang.getText()).append("\n");
        nota.append("Kembali: ").append(this.kembali.getText()).append("\n");
        nota.append("------------------------------\n");
        nota.append("Terima Kasih\n");
        return nota.toString();
    }

    private void printNota(final String nota) {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = printerJob.defaultPage();
            Paper paper = pageFormat.getPaper();
            double width = 283.46456692913387;
            double height = this.calculatePrintableHeight(nota);
            paper.setSize(width, height);
            paper.setImageableArea(0.0, 0.0, width, height);
            pageFormat.setPaper(paper);
            printerJob.setPrintable(new Printable(){

                @Override
                public int print(Graphics g, PageFormat format, int pageIndex) throws PrinterException {
                    String[] lines;
                    int lineHeight;
                    if (pageIndex > 0) {
                        return 1;
                    }
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.translate(format.getImageableX(), format.getImageableY());
                    g2d.setFont(new Font("Monospaced", 0, 10));
                    FontMetrics metrics = g2d.getFontMetrics();
                    int y = lineHeight = metrics.getHeight();
                    for (String line : lines = nota.split("\n")) {
                        g2d.drawString(line, 0, y);
                        y += lineHeight;
                    }
                    return 0;
                }
            });
            if (printerJob.printDialog()) {
                printerJob.print();
            }
        }
        catch (PrinterException e) {
            JOptionPane.showMessageDialog(null, "Gagal mencetak nota: " + e.getMessage());
        }
    }

    private double calculatePrintableHeight(String nota) {
        FontMetrics metrics = new FontMetrics(new Font("Monospaced", 0, 10)){};
        int lineHeight = metrics.getHeight();
        int lines = nota.split("\n").length;
        return lineHeight * lines;
    }

    private void initComponents() {
        this.jButton4 = new JButton();
        this.nohp_pelanggan = new JTextField();
        this.namapelanggan = new JTextField();
        this.kodebarang = new JTextField();
        this.namabarang = new JTextField();
        this.harga = new JTextField();
        this.jmlhbrg = new JTextField();
        this.uang = new JTextField();
        this.kembali = new JTextField();
        this.carinohppelanggan = new JButton();
        this.carikodebarang = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.hitungbelanja = new JButton();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.bayarbelanja = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tabelpenjualan = new JTable();
        this.tgl = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.tabelbelanja = new JTable();
        this.jLabel13 = new JLabel();
        this.totalbelanja = new JTextField();
        this.totalsemuabelanja = new JButton();
        this.txtCari = new JTextField();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.jButton4.setFont(new Font("Times New Roman", 1, 14));
        this.jButton4.setText("KEMBALI");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.jButton4ActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.jButton4, new AbsoluteConstraints(1380, 350, 109, -1));
        this.nohp_pelanggan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.nohp_pelangganActionPerformed(evt);
            }
        });
        this.nohp_pelanggan.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                jualan.this.nohp_pelangganKeyPressed(evt);
            }
        });
        this.getContentPane().add((Component)this.nohp_pelanggan, new AbsoluteConstraints(210, 170, 270, 30));
        this.namapelanggan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.namapelangganActionPerformed(evt);
            }
        });
        this.namapelanggan.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                jualan.this.namapelangganKeyPressed(evt);
            }
        });
        this.getContentPane().add((Component)this.namapelanggan, new AbsoluteConstraints(210, 210, 270, 30));
        this.kodebarang.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.kodebarangActionPerformed(evt);
            }
        });
        this.kodebarang.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                jualan.this.kodebarangKeyPressed(evt);
            }
        });
        this.getContentPane().add((Component)this.kodebarang, new AbsoluteConstraints(210, 250, 270, 30));
        this.namabarang.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.namabarangActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.namabarang, new AbsoluteConstraints(210, 300, 270, 30));
        this.harga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.hargaActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.harga, new AbsoluteConstraints(750, 130, 243, 30));
        this.jmlhbrg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.jmlhbrgActionPerformed(evt);
            }
        });
        this.jmlhbrg.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                jualan.this.jmlhbrgKeyPressed(evt);
            }
        });
        this.getContentPane().add((Component)this.jmlhbrg, new AbsoluteConstraints(750, 170, 243, 30));
        this.uang.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.uangActionPerformed(evt);
            }
        });
        this.uang.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                jualan.this.uangKeyPressed(evt);
            }
        });
        this.getContentPane().add((Component)this.uang, new AbsoluteConstraints(750, 270, 243, 30));
        this.kembali.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.kembaliActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.kembali, new AbsoluteConstraints(750, 310, 244, 30));
        this.carinohppelanggan.setText("CARI");
        this.carinohppelanggan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.carinohppelangganActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.carinohppelanggan, new AbsoluteConstraints(480, 170, -1, -1));
        this.carikodebarang.setText("CARI");
        this.carikodebarang.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.carikodebarangActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.carikodebarang, new AbsoluteConstraints(480, 260, -1, -1));
        this.jLabel2.setFont(new Font("Times New Roman", 1, 16));
        this.jLabel2.setText("TANGGAL");
        this.getContentPane().add((Component)this.jLabel2, new AbsoluteConstraints(10, 130, -1, -1));
        this.jLabel3.setFont(new Font("Times New Roman", 1, 16));
        this.jLabel3.setText("NOMOR HP");
        this.getContentPane().add((Component)this.jLabel3, new AbsoluteConstraints(10, 170, -1, -1));
        this.jLabel4.setFont(new Font("Times New Roman", 1, 16));
        this.jLabel4.setText("NAMA PELANGGAN");
        this.getContentPane().add((Component)this.jLabel4, new AbsoluteConstraints(10, 220, -1, -1));
        this.jLabel5.setFont(new Font("Times New Roman", 1, 16));
        this.jLabel5.setText("KODE BARANG");
        this.getContentPane().add((Component)this.jLabel5, new AbsoluteConstraints(10, 260, -1, -1));
        this.jLabel6.setFont(new Font("Times New Roman", 1, 16));
        this.jLabel6.setText("CARI DATA");
        this.getContentPane().add((Component)this.jLabel6, new AbsoluteConstraints(20, 380, -1, -1));
        this.jLabel9.setFont(new Font("Times New Roman", 1, 16));
        this.jLabel9.setText("NAMA BARANG");
        this.getContentPane().add((Component)this.jLabel9, new AbsoluteConstraints(10, 310, -1, -1));
        this.jLabel7.setFont(new Font("Times New Roman", 1, 16));
        this.jLabel7.setText("HARGA BARANG");
        this.getContentPane().add((Component)this.jLabel7, new AbsoluteConstraints(580, 130, -1, -1));
        this.jLabel8.setFont(new Font("Times New Roman", 1, 16));
        this.jLabel8.setText("JUMLAH BARANG");
        this.getContentPane().add((Component)this.jLabel8, new AbsoluteConstraints(570, 180, -1, -1));
        this.hitungbelanja.setText("MASUKAN");
        this.hitungbelanja.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.hitungbelanjaActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.hitungbelanja, new AbsoluteConstraints(1000, 180, -1, -1));
        this.jLabel10.setFont(new Font("Times New Roman", 1, 16));
        this.jLabel10.setText("MASUKAN UANG");
        this.getContentPane().add((Component)this.jLabel10, new AbsoluteConstraints(570, 270, -1, -1));
        this.jLabel11.setFont(new Font("Times New Roman", 1, 16));
        this.jLabel11.setText("KEMBALIAN");
        this.getContentPane().add((Component)this.jLabel11, new AbsoluteConstraints(570, 320, -1, -1));
        this.bayarbelanja.setText("BAYAR");
        this.bayarbelanja.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.bayarbelanjaActionPerformed(evt);
            }
        });
        this.bayarbelanja.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                jualan.this.bayarbelanjaKeyPressed(evt);
            }
        });
        this.getContentPane().add((Component)this.bayarbelanja, new AbsoluteConstraints(1000, 270, -1, -1));
        this.tabelpenjualan.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tabelpenjualan.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                jualan.this.tabelpenjualanMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tabelpenjualan);
        this.getContentPane().add((Component)this.jScrollPane1, new AbsoluteConstraints(10, 410, 1480, 480));
        this.tgl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.tglActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.tgl, new AbsoluteConstraints(210, 130, 270, 30));
        this.tabelbelanja.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.tabelbelanja);
        this.getContentPane().add((Component)this.jScrollPane2, new AbsoluteConstraints(1100, 120, 390, 204));
        this.jLabel13.setFont(new Font("Times New Roman", 1, 16));
        this.jLabel13.setText("TOTAL SEMUA");
        this.getContentPane().add((Component)this.jLabel13, new AbsoluteConstraints(570, 230, -1, -1));
        this.totalbelanja.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.totalbelanjaActionPerformed(evt);
            }
        });
        this.totalbelanja.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                jualan.this.totalbelanjaKeyPressed(evt);
            }
        });
        this.getContentPane().add((Component)this.totalbelanja, new AbsoluteConstraints(750, 220, 243, 30));
        this.totalsemuabelanja.setText("TOTAL");
        this.totalsemuabelanja.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jualan.this.totalsemuabelanjaActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.totalsemuabelanja, new AbsoluteConstraints(1000, 220, -1, -1));
        this.getContentPane().add((Component)this.txtCari, new AbsoluteConstraints(120, 370, 220, 30));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/bg/KASIR-01-01.jpg")));
        this.getContentPane().add((Component)this.jLabel1, new AbsoluteConstraints(0, 0, 1500, 910));
        this.pack();
    }

    private void nohp_pelangganActionPerformed(ActionEvent evt) {
    }

    private void namapelangganActionPerformed(ActionEvent evt) {
    }

    private void kodebarangActionPerformed(ActionEvent evt) {
    }

    private void namabarangActionPerformed(ActionEvent evt) {
    }

    private void hargaActionPerformed(ActionEvent evt) {
    }

    private void jmlhbrgActionPerformed(ActionEvent evt) {
    }

    private void uangActionPerformed(ActionEvent evt) {
    }

    private void kembaliActionPerformed(ActionEvent evt) {
    }

    private void carinohppelangganActionPerformed(ActionEvent evt) {
        String nohp = this.nohp_pelanggan.getText();
        if (nohp.isEmpty()) {
            JOptionPane.showMessageDialog(null, "Masukkan nomor HP pelanggan.");
            return;
        }
        try {
            String sql = "SELECT nama FROM pelanggan WHERE nohp = ?";
            PreparedStatement stat = this.conn.prepareStatement(sql);
            stat.setString(1, nohp);
            ResultSet res = stat.executeQuery();
            if (res.next()) {
                String namaPelanggan = res.getString("nama");
                this.namapelanggan.setText(namaPelanggan);
                JOptionPane.showMessageDialog(null, "Nama pelanggan ditemukan. Silakan lanjutkan penginputan data.");
                this.nohp_pelanggan.setEnabled(false);
                this.namapelanggan.setEnabled(false);
                this.carinohppelanggan.setEnabled(false);
            } else {
                JOptionPane.showMessageDialog(null, "Pelanggan tidak ditemukan.");
                this.namapelanggan.setText("");
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage());
        }
    }

    private void carikodebarangActionPerformed(ActionEvent evt) {
        String kodeBarang = this.kodebarang.getText();
        if (kodeBarang.isEmpty()) {
            JOptionPane.showMessageDialog(null, "Silakan masukkan kode barang.");
            return;
        }
        try {
            String sql = "SELECT nm_brg, hrg FROM barang WHERE kd_brg = ?";
            PreparedStatement stat = this.conn.prepareStatement(sql);
            stat.setString(1, kodeBarang);
            ResultSet res = stat.executeQuery();
            if (res.next()) {
                String namaBarang = res.getString("nm_brg");
                double hargaBarang = res.getDouble("hrg");
                this.namabarang.setText(namaBarang);
                this.harga.setText(String.valueOf(hargaBarang));
                this.kodebarang.setEnabled(false);
                this.namabarang.setEnabled(false);
                this.harga.setEnabled(false);
                JOptionPane.showMessageDialog(null, "Kode barang ditemukan. Silakan lanjutkan penginputan.");
            } else {
                JOptionPane.showMessageDialog(null, "Kode barang tidak ditemukan.");
                this.namabarang.setText("");
                this.harga.setText("");
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage());
        }
    }

    private void hitungbelanjaActionPerformed(ActionEvent evt) {
        this.masukkanKeTabel();
        this.hitungBelanja();
        this.totalSemuaBelanja();
        this.aktifkanFieldTertentu();
    }

    private void bayarbelanjaActionPerformed(ActionEvent evt) {
        this.bayarBelanja();
    }

    private void tglActionPerformed(ActionEvent evt) {
    }

    private void nohp_pelangganKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.carinohppelangganActionPerformed(null);
            this.kodebarang.requestFocus();
        }
    }

    private void namapelangganKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.kodebarang.requestFocus();
        }
    }

    private void kodebarangKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.carikodebarangActionPerformed(null);
            this.jmlhbrg.requestFocus();
        }
    }

    private void jmlhbrgKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.masukkanKeTabel();
            this.totalSemuaBelanja();
            this.totalbelanja.setEnabled(false);
            this.nohp_pelanggan.requestFocus();
            this.aktifkanFieldTertentu();
        }
    }

    private void aktifkanFieldTertentu() {
        this.nohp_pelanggan.setEnabled(true);
        this.kodebarang.setEnabled(true);
        this.namabarang.setEnabled(true);
        this.jmlhbrg.setEnabled(true);
        this.harga.setEnabled(true);
    }

    private void uangKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.bayarBelanja();
        }
    }

    private void totalbelanjaActionPerformed(ActionEvent evt) {
    }

    private void totalbelanjaKeyPressed(KeyEvent evt) {
    }

    private void totalsemuabelanjaActionPerformed(ActionEvent evt) {
        this.totalSemuaBelanja();
    }

    private void bayarbelanjaKeyPressed(KeyEvent evt) {
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        new menu().show();
        this.dispose();
    }

    private void tabelpenjualanMouseClicked(MouseEvent evt) {
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(jualan.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(jualan.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(jualan.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(jualan.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new jualan().setVisible(true);
            }
        });
    }
}

